#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: Request.py 9621 2016-04-06 13:36:10Z Eric $
#
# Copyright (c) 2012 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Eric $
# $Date: 2016-04-06 21:36:10 +0800 (Wed, 06 Apr 2016) $
# $Revision: 9621 $
"""
Request for webkit implementation.
"""

import sys
import os
import platform
import threading

from .. import Interprocess

class Impl(Interprocess.Request):
    """
    Request for WebKit implementation.
    """
    
    LOCK = threading.RLock()
            
    if sys.platform.startswith('win'):
        if platform.architecture()[0] == '64bit':       
            from win32 import WebKitImplClient as CLIENT
            EXE_FOLDER = os.path.join(os.path.dirname(__file__), 'win32')
            
        EXE = os.path.normpath(os.path.join(EXE_FOLDER, 'WebKitImpl.exe'))
        
    elif sys.platform.startswith('linux'):
        if platform.architecture()[0] == '32bit':       
            from linux_x86 import WebKitImplClient as CLIENT
            EXE_FOLDER = os.path.join(os.path.dirname(__file__), 'linux_x86')
        elif platform.architecture()[0] == '64bit':
            from linux_x64 import WebKitImplClient as CLIENT
            EXE_FOLDER = os.path.join(os.path.dirname(__file__), 'linux_x64')
            
        EXE = os.path.normpath(os.path.join(EXE_FOLDER, 'WebKitImpl'))

    def handleError(self, error, url, options, response):
        if error in (401, 403):
            from .. import AccessDeniedError
            raise AccessDeniedError(url, error)
        elif 400 <= error <= 505:
            from .. import HttpError
            raise HttpError(url, error)
        else:
            from .. import ConnectionError
            raise ConnectionError(url, error)

#Interprocess.kill(Impl)
