#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: LocalTest.py 11172 2018-07-16 09:31:00Z Lavender $
#
# Copyright (c) 2015 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $ (last)
# $Date: 2018-07-16 18:31:00 +0900 (週一, 16 七月 2018) $
# $Revision: 11172 $

from Iuppiter import test as TestUtil

TestUtil.chdirToRootDir()

import os
import unittest

import Iuno.cloud
from Iuno.cloud.queue.backend import Local

class LocalTest(unittest.TestCase):

    def testBySettings(self):
        """
        Test Local backend configuration by settings.
        """
        settings = {
            'INSTALLED_APPS': (),
        }

        Iuno.cloud.attachSettings(settings, services=('queue',),
                                  serviceSettings={
                                      'queue': {
                                          'backendClasses': (Local.Backend,),
                                      },
                                  },
                                  cache=True, loggingLevel='DEBUG')

        settings = {
            'INSTALLED_APPS': (),
            'IUNO_CLOUD_QUEUE_BACKEND_HOST': 'naga.servehttp.com',
            'HOST_OS': 'windows',
            'BROKER_USER': 'test',
            'BROKER_PASSWORD': 'test',
        }

        Iuno.cloud.attachSettings(settings, services=('queue',),
                                  serviceSettings={
                                      'queue': {
                                          'backendClasses': (Local.Backend,),
                                      },
                                  },
                                  cache=True, loggingLevel='DEBUG')
        
        self.assertEqual(settings['BROKER_URL'], 
                         'amqp://test:test@naga.servehttp.com:5672/')
        self.assertEqual(settings['CELERY_RESULT_BACKEND'], 
                         'redis://:25025529@naga.servehttp.com:25025529')

    def testByConfig(self):
        """
        Test Local backend configuration by configuration file.
        """
        settings = {
            'INSTALLED_APPS': (),
            'IUNO_CLOUD_QUEUE_LOCAL_CONFIG':
                os.path.abspath(os.path.join(os.path.dirname(__file__),
                                'LocalTest.ini'))
        }

        Iuno.cloud.attachSettings(settings, services=('queue',),
                                  serviceSettings={
                                      'queue': {
                                          'backendClasses': (Local.Backend,),
                                      },
                                  },
                                  cache=True, loggingLevel='DEBUG')

        self.assertEqual(settings['BROKER_URL'], 
                         'amqp://test:test@127.0.0.1:5672/')
        self.assertEqual(settings['CELERY_RESULT_BACKEND'], 
                         'redis://:redis@127.0.0.1:redis')

if __name__ == "__main__":
    unittest.main()
