#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: Utility.py 10447 2017-11-06 23:27:59Z David $
#
# Copyright (c) 2012 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: David $
# $Date: 2017-11-07 07:27:59 +0800 (Tue, 07 Nov 2017) $
# $Revision: 10447 $

import sys
import traceback

from bs4 import BeautifulSoup

from django.template.defaultfilters import slugify
from django.core.urlresolvers import reverse
from django.conf import settings

from unidecode import unidecode

from Iuppiter.Encoding import _unicode

from Theophrastus.models import Link

def trackLinks(content, context):
    """
    Convert all links in the template for the user to track his navigation.

    @param content Newsletter content.
    @param context Context.
    """
    if not context.get('uidb36'):
        return content
    
    if (hasattr(settings, 'SECURE_PROXY_SSL_HEADER') and
        settings.SECURE_PROXY_SSL_HEADER):
        protocol = 'https'
    else:
        protocol = 'http'

    soup = BeautifulSoup(content)
    for linkMarkup in soup('a'):
        if linkMarkup.get('href'):
            linkHref = linkMarkup['href']
            if linkHref == '#' or linkHref == '':
                # We don't need to save if link was # or empty.
                continue

            linkTitle = linkMarkup.get('title', linkHref)
            hasExist = Link.objects.filter(url=linkHref)
            if hasExist:
                link = hasExist[0]
            else:
                link = Link.objects.create(
                    url=linkHref, title=linkTitle)

            TrackingLink = reverse(
                'newsletter_newsletter_tracking_link',
                args=[context['newsletter'].slug,
                      context['uidb36'], context['token'],
                      link.pk]
            )
            linkMarkup['href'] = '%s://%s%s' % (
                protocol, context['domain'], TrackingLink)

    return soup.prettify()

def _slugify(context):
    """
    Get slug name.

    @param request Request instance.
    """
    slug = unidecode(_unicode(context, strict=True))
    slug = slug.strip()
    slug = '_'.join(slug.split(' '))
    slug = slugify(slug.lower())
    return str(slug)

def getComment(e):
    """
    Comment for error exception.

    @param e Error exception.
    """
    c = '\n'.join(traceback.format_tb(sys.exc_info()[-1]))
    return '%s\n%s\n' % (c, _unicode(e))
