#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: create_zip.py 10626 2017-12-10 09:05:41Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2017-12-10 17:05:41 +0800 (週日, 10 十二月 2017) $
# $Revision: 10626 $

import os
import shutil
import zipfile
import json
import hashlib
import datetime
import traceback

from django.core.management.base import BaseCommand, CommandError
from django.template.loader import get_template
from django.template import Context

from Zephyrus.boilerplate.management.commands import (
    TEMPLATES_DIR_PATH, STATIC_DIR_PATH, 
    IMAGES_DIR_PATH, ROOT_DIR_PATH, FIXTURES_DIR_PATH)
from Zephyrus.boilerplate.management.commands import createLogger
from Zephyrus import ZEPHYRUS_VERSION
from Iuppiter.Encoding import utf8

logger = createLogger(__name__, "CreateZip.log")

class Command(BaseCommand):

    help = 'Create zip file to destination folder.'
    
    def add_arguments(self, parser):
        parser.add_argument('path', type=str, help="destination folder")
        parser.add_argument(
            '-o', '--onlyTemplate', 
            action='store_true',
            help="Only output template zip. Not have template shop info")
            
        parser.add_argument(
            '-n', '--templateName', 
            type=str, default='template',
            help="Use the name to create template zip name.")

    def handle(self, *args, **options):
        try:
            if os.path.isfile(os.path.join(ROOT_DIR_PATH, 'info.json')):
                with open(os.path.join(ROOT_DIR_PATH, 'info.json')) as jsonfile:
                    data = json.load(jsonfile)

                upc = data['upc']
                complexity = data['complexity']

                content = ''
                for root, dirs, files in os.walk(TEMPLATES_DIR_PATH):
                    for temp in files:
                        with open(os.path.join(root, temp)) as f:
                            htmlContent = f.read()
                        include = (("include '_tracking.html' with"
                                    " upc='%s' complexity='%d'") % (
                                        str(upc), complexity))
                        htmlContent = htmlContent.replace(
                            "<!--### include _tracking.html ###-->",
                            "{% " + include + " %}") 
                        with open(os.path.join(root, temp), 'wb') as f:
                            f.write(utf8(htmlContent))
                        content += htmlContent
                data['checksum'] = hashlib.md5(content).hexdigest()

                with open(os.path.join(ROOT_DIR_PATH, 'info.json'), 'w') as f:
                    line = json.dumps(data)
                    f.write(line)

                temp = get_template('boilerplate/html/Tracking.html')
                content = temp.render()
                with open(os.path.join(
                    TEMPLATES_DIR_PATH, '_tracking.html'), 'wb') as f:
                    f.write(utf8(content))
                with open(os.path.join(
                    ROOT_DIR_PATH, 'MANIFAST.INFO'), 'wb') as f:
                    manifast = json.dumps({
                        'upc': upc, 
                        'complexity': complexity,
                        'createTime': str(datetime.datetime.now()),
                        'ZephyrusVersion': ZEPHYRUS_VERSION,
                    })
                    f.write(utf8(manifast))
                    
            templateName = options['templateName']

            zip = zipfile.ZipFile(
                os.path.join(ROOT_DIR_PATH, '%s.zip' % templateName), mode='w')

            logger.info("-----Start copy templates-----")
            for root, dirs, files in os.walk(TEMPLATES_DIR_PATH):
                for f in files:
                    path = os.path.join(root, f)
                    dst = "./templates/%s" % f
                    logger.info("Zip " + path)
                    zip.write(path, dst)
            
            
            index = len(STATIC_DIR_PATH) + 1
            for root, dirs, files in os.walk(STATIC_DIR_PATH):
                for f in files:
                    path = os.path.join(root, f)
                    
                    dst = "./static/%s" % path[index:]
                    logger.info("Zip " + path)
                    zip.write(path, dst)
            for root, dirs, files in os.walk(FIXTURES_DIR_PATH):
                for f in files:
                    path = 'fixtures/%s' % f
                    logger.info("Zip " + path)
                    zip.write(path)

            temp = get_template('boilerplate/py/setup.py')
            content = temp.render()
            with open(os.path.join(ROOT_DIR_PATH, 'setup.py'), 'wb') as f:
                f.write(utf8(content))
                
            temp = get_template('boilerplate/txt/README.txt')
            content = temp.render()
            with open(os.path.join(ROOT_DIR_PATH, 'README.txt'), 'w') as f:
                f.write(utf8(content))

            zip.write('./README.txt')
            logger.info("Zip README.txt")
            
            zip.write('./setup.py')
            logger.info("Zip setup.py")

            if os.path.isfile(os.path.join(ROOT_DIR_PATH, 'info.json')):
                zip.write('MANIFAST.INFO')
                logger.info("Zip MANIFAST.INFO")
                
            zip.close()

            dst = options['path']

            if not options['onlyTemplate']:
                if os.path.isfile(os.path.join(ROOT_DIR_PATH, 'info.json')):
                    zip = zipfile.ZipFile(
                        os.path.join(dst, '%s.zip' % data['upc']), mode='w')
                    zip.write('info.json')
                else:
                    zip = zipfile.ZipFile(
                        os.path.join(dst, '%s.zip' % 'TemplateShop'), mode='w')
                
                for root, dirs, files in os.walk(IMAGES_DIR_PATH):
                    for file in files:
                        path = 'images/%s' % file
                        logger.info("Zip " + path)
                        zip.write(path)
                        
                zip.write('%s.zip' % templateName)
                zip.close()
            else:      
                shutil.copyfile(
                    './%s.zip' % templateName, 
                    os.path.join(dst, '%s.zip' % templateName))
            
            if os.path.exists(FIXTURES_DIR_PATH):
                shutil.rmtree(FIXTURES_DIR_PATH)
            if os.path.exists(IMAGES_DIR_PATH):
                shutil.rmtree(IMAGES_DIR_PATH)
            if os.path.isfile('./README.txt'):
                os.remove('./README.txt')
            if os.path.isfile('./setup.py'):
                os.remove('./setup.py')
            if os.path.isfile('./info.json'):
                os.remove('./info.json')
            if os.path.isfile('./MANIFAST.INFO'):
                os.remove('./MANIFAST.INFO')
            if os.path.isfile('./%s.zip' % templateName):
                os.remove('./%s.zip' % templateName)
            
            logger.info('-----All OK!-----')
        except Exception as e:
            logger.error("create_zip error:%s" % e)
            with open('./AllError.log', 'w+') as log:
                log.write(traceback.format_exc())
            raise