#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: ThankRedirect.py 9868 2017-04-16 09:05:26Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2017-04-16 17:05:26 +0800 (週日, 16 四月 2017) $
# $Revision: 9868 $

from django import template
from django.utils.safestring import mark_safe
from django.conf import settings

register = template.Library()

@register.simple_tag
def ThankRedirect(request):
    fromUrl = request.GET.get('fromurl')
    if fromUrl == None:
        return ''
    
    try:
        time = settings.ZEPHYRUS_LANDING_THANK_WAIT_TIME
    except Exception as e:
        time = 3000
    return mark_safe(
        '''
        <script>
            var redirect = function(){
                setTimeout(function(){window.location.replace('%s');}, %d);
            };
            redirect();
        </script>
        ''' % (fromUrl, time)
    )
