#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: views.py 9868 2017-04-16 09:05:26Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2017-04-16 17:05:26 +0800 (週日, 16 四月 2017) $
# $Revision: 9868 $

import datetime
import logging
import re

from django.shortcuts import redirect
from django.contrib import messages
from django.views.generic import View
from django.core.mail import send_mail
from django.conf import settings
from django.template.loader import get_template
from django.template import Context
from django.contrib import auth

from models import Email

logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)
logger.addHandler(logging.StreamHandler())

#ERROR_CODES
NORMAL = 0
SAVE_ERROR = 1
SEND_ERROR = 2
EMAIL_FORMAT_ERROR = 3

def sendAndRedirect(request, email, fromUrl, redirectTo):
        errorCode = NORMAL
        
        if re.match(r'(\w+@[a-zA-Z_]+?\.[a-zA-Z]{2,6})', email):
            try:
                email = Email.objects.create(
                    email=email,
                    fromUrl=fromUrl,    
                )
                email.save()
            except Exception as e:
                errorCode = SAVE_ERROR
                logger.error('Not successfully save email: %s' % str(e))

            try:
                message = (
                    "Customer id : %d\nCustomer email : %s\n" % 
                    (email.id, email.email))
                message += "Date : %s" % datetime.datetime.now()
                
                title = (
                    '[Landing %s] - customer use landing page' % 
                    request.META['HTTP_HOST'])
                    
                send_mail(
                    title,
                    message,
                    settings.EMAIL_HOST_USER,
                    settings.ZEPHYRUS_LANDING_SEND_TO,
                    fail_silently=False
                )
                
                mail = get_template('landing/CustomerMail.txt')
                replaceStr = Context({
                    'email': email.email,
                })
                
                title = get_template('landing/CustomerMailSubject.txt')
                
                send_mail(
                    title.render(),
                    mail.render(replaceStr),
                    settings.EMAIL_HOST_USER,
                    [email.email,],
                    fail_silently=False
                )
            except Exception as e:
                errorCode = SEND_ERROR
                logger.error('Not successfully send email: %s' % str(e))
        else:
            errorCode = EMAIL_FORMAT_ERROR
        
        if redirectTo:        
            url = redirectTo
        else:
            url = fromUrl + settings.ZEPHYRUS_LANDING_THANK_PATH
            
        url = url + "?fromurl=%s&errorcode=%d" % (fromUrl, errorCode)

        return redirect(url)
    
class EmailView(View):  
    def post(self, request, *args, **kwargs):
        email = request.POST.get('email')
        fromUrl = request.POST.get('fromUrl')
        redirectTo = request.POST.get('redirectTo')
        return sendAndRedirect(request, email, fromUrl, redirectTo)
            
class LandingSocialView(View):
    def get(self, request, *args, **kwargs):
        user = request.user
        email = user.email
        fromUrl = request.GET.get('fromUrl')
        redirectTo = request.GET.get('redirectTo')
        auth.logout(request)
        return sendAndRedirect(request, email, fromUrl, redirectTo)