#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: __init__.py 11616 2019-06-07 02:15:46Z Andy $
#
# Copyright (c) 2018 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Andy $
# $Date: 2019-06-07 11:15:46 +0900 (週五, 07 六月 2019) $
# $Revision: 11616 $

from django.conf.urls import url, include

def attachURLs(settings, urlpatterns):
    """
    Attach patched (for example, debug and admin...etc.) urlpatterns.
    It must be called in urls.py by passing urlpatterns.

    @param settings Django project's settings module.
    @param urlpatterns urlpatterns in urls.py.
    """

    # Theophrastus newsletter document url
    if 'Theophrastus.document' in settings.INSTALLED_APPS:
        urlpatterns += [
            url(r'^admin/', include('Theophrastus.document.urls')),
        ]

    # Theophrastus newsletter urls
    urlpatterns += [
        url(r'^newsletters/', include('Theophrastus.urls')),
    ]
    
    # Tinymic editor.
    if 'Theophrastus.editor' in settings.INSTALLED_APPS:
        urlpatterns += [
            url(r'^tinymce/', include('tinymce.urls')),
        ]