#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: get_template.py 9906 2017-04-23 15:13:49Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2017-04-23 23:13:49 +0800 (週日, 23 四月 2017) $
# $Revision: 9906 $

import os
import logging
import shutil

from django.core.management.base import BaseCommand, CommandError
from django.conf import settings

logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)
handler = logging.StreamHandler()
handler.setFormatter(
    logging.Formatter("%(asctime)s - %(levelname)s - %(message)s"))
logger.addHandler(handler)

if hasattr(settings, 'TEMPLATES'):
    TEMPLATES_DIR_PATH = settings.TEMPLATES[0]['DIRS'][0]
else:
    TEMPLATES_DIR_PATH = os.path.abspath(
        os.path.join('.', 'templates'))

if settings.DEBUG:
    if hasattr(settings, 'STATICFILES_DIRS'):
        STATIC_DIT_PATH = settings.STATICFILES_DIRS[0]
    else:
        STATIC_DIT_PATH = os.path.abspath(
            os.path.join('.', 'static'))
else:
    if hasattr(settings, 'STATIC_ROOT'):
        STATIC_DIT_PATH = settings.STATIC_ROOT
    else:
        STATIC_DIT_PATH = os.path.abspath(
            os.path.join('.', 'static'))
    
IMAGES_DIT_PATH = os.path.abspath(
    os.path.join('.', 'images'))

ROOT_DIR_PATH = os.path.abspath(
    os.path.join('.'))

class Command(BaseCommand):

    help = 'Copy html to templates and copy static files to static.'
    args = '<destination folder>'

    def handle(self, *args, **options):
        if len(args) < 1:
            raise CommandError(
                "You must specify a folder to get template."
                )

        path = args[0]

        try:
            shutil.rmtree(TEMPLATES_DIR_PATH)
            logger.info("Remove Temeplates folder.")
        except Exception as e:
            logger.error("Temeplates folder is not exist.")
            os.mkdir(TEMPLATES_DIR_PATH)
        else:
            os.mkdir(TEMPLATES_DIR_PATH)
            logger.info("Create Temeplates folder.")

        try:
            shutil.rmtree(STATIC_DIT_PATH)
            logger.info("Remove static folder.")
        except Exception as e:
            logger.error("Static folder is not exist.")
            os.mkdir(STATIC_DIT_PATH)
        else:
            os.mkdir(STATIC_DIT_PATH)
            logger.info("Create static folder.")
            
        try:
            shutil.rmtree(IMAGES_DIT_PATH)
            logger.info("Remove images folder.")
        except Exception as e:
            logger.error("Images folder is not exist.")
            

        logger.info("-----Start copy templates-----")
        
        imgPath = os.path.join(path, 'images')
        shutil.copytree(imgPath, IMAGES_DIT_PATH)
        logger.info("Copy images folder to root.")


        for root, dirs, files in os.walk(path):
            if 'info.json' in files:
                jsonPath = os.path.join(root, 'info.json')           
                jsonDst = os.path.join(ROOT_DIR_PATH, 'info.json')
                shutil.copyfile(jsonPath, jsonDst)
                logger.info('Copy %s to root.' % 'info.json')

            if "index.html" in files or "Index.html" in files:
                for fileName in files:
                    filePath = os.path.join(root, fileName)
                    if fileName.endswith('.html'):
                        dst = os.path.join(TEMPLATES_DIR_PATH, fileName)
                        shutil.copyfile(filePath, dst)
                        logger.info(
                            'Copy %s to templates folder.' % fileName)
                    else:
                        dst = os.path.join(STATIC_DIT_PATH, fileName)
                        shutil.copyfile(filePath, dst)
                        logger.info('Copy %s to static folder.' % fileName)
                for dirName in dirs:
                    dirPath = os.path.join(root, dirName)
                    dst = os.path.join(STATIC_DIT_PATH, dirName)
                    shutil.copytree(dirPath, dst)
                    logger.info('Copy %s to static folder.' % dirName)
                break

        logger.info('-----All OK!-----')