#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: admin.py 9948 2017-05-07 06:08:11Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2017-05-07 14:08:11 +0800 (�g��, 07 ���� 2017) $
# $Revision: 9948 $

import requests
import json

from cms.plugin_base import CMSPluginBase
from cms.plugin_pool import plugin_pool
from django.utils.translation import ugettext as _
from django.conf import settings
from django.utils.safestring import mark_safe
from django.template.loader import select_template

from Zephyrus.facebook import settings as zephyrusSettings
from Zephyrus.facebook.models import FacebookFan, FacebookPhoto

class Subattachment(object):
    def __init__(self, title, subattachmentType, img, url):
        self.title = title
        self.type = subattachmentType
        self.img = img
        self.url = url


class FanPage(object):
    def __init__(self, id, createdTime, msg,  mainImgUrl, postType, url, 
                 subattachments):
        self.id = id
        self.createdTime = createdTime
        self.type = postType
        self.img = mainImgUrl
        self.msg = msg
        self.url = url
        self.subattachments = subattachments
        
class Photo(object):
    def __init__(self, name, url, link):
        self.name = name
        self.url = url
        self.link = link
        
def getFanPageId(accessToken, url):
    # get fan page id
    fanPageUrl = url
    if not fanPageUrl.endswith('/'):
        fanPageUrl += '/'
    req = requests.get(
        ("https://graph.facebook.com/v2.8/%s?access_token=%s&debug=all"
         "&format=json&method=get&pretty=0&suppress_http_code=1") % (
         fanPageUrl, accessToken))
    text = req.text

    data = json.loads(text)
    
    if data.get('name') and data.get('id'):
        fanPageId = json.loads(text)['id']
        return fanPageId
    else:
        return None

class FacebookFanPlugin(CMSPluginBase):
    model = FacebookFan
    module = _("Zephyrus Facebook")
    name = _("Facebook Fan Page")
    render_template = zephyrusSettings.ZEPHYRUS_FACEBOOK_FAN_DEFAULT_TEMPLATE

    def get_fieldsets(self, request, obj=None):
        fieldsets = (
            (None, {
                'description': _('<h2>Main:</h2>'),
                'fields': ('url', 'limit',),
            }),
            (None, {
                'description': _('<h2>Choose article display mode:</h2>'),
                'fields': ('unknownDisplay', 'videoDisplay', 'albumDisplay', 
                           'shareDisplay', 'commerceDisplay', 
                           'onlyMessageDisplay',),
            }),
            (None, {
                'description': _('<h2>Other:</h2>'),
                'fields': ('renderTemplate',),
            }),
        )
        return fieldsets

    def get_render_template(self, context, instance, placeholder):
        return select_template([
            instance.renderTemplate,
            zephyrusSettings.ZEPHYRUS_FACEBOOK_FAN_DEFAULT_TEMPLATE,
        ])

    def render(self, context, instance, placeholder):
        accessToken = '%s|%s' % (
            settings.SOCIAL_AUTH_FACEBOOK_KEY, 
            settings.SOCIAL_AUTH_FACEBOOK_SECRET
        )
        fanPageUrl = instance.url
        fanPageId = getFanPageId(accessToken, instance.url)

        # article type filter
        articleTypes = []
        onlyMsg = instance.onlyMessageDisplay
        if instance.unknownDisplay:
            articleTypes.append('unknown')
        if instance.videoDisplay:
            articleTypes.append('video') 
        if instance.albumDisplay:
            articleTypes.append('photo')
            articleTypes.append('album')
        if instance.shareDisplay:
            articleTypes.append('share')
        if instance.commerceDisplay:
            articleTypes.append('commerce')
        
        if not fanPageId:
            # ��}�ݲŦX���T�榡
            context.update({
                'error': _('Url must conform correct format, '
                           'EX: https://www.facebook.com/xxx/'),
            })
            return context
        
        # get data
        query = ("posts?fields=attachments,link,created_time,message"
                 "&limit=100")
        req = requests.get(
            'https://graph.facebook.com/v2.8/%s/%s&access_token=%s' % (
            fanPageId, query, accessToken)
            )   

        if json.loads(req.text).get('error', {}).get('message'):
            context.update({
                'error': json.loads(req.text).get('error', {}).get('message'),
            })
            return context

        nextPage = None

        fpList = []

        while len(fpList) < instance.limit: 
            if nextPage:
                if nextPage == 'End':
                    break
                req = requests.get(nextPage)

            content = json.loads(req.text).get('data')
            nextPage = json.loads(req.text).get('paging', {}).get('next', 'End')

            # create objects
            for data in content:
                id = data.get('id')
                createdTime = data.get('created_time')
                link = data.get('link')
                msg = mark_safe(data.get('message', '').replace('\n', '<br />'))
                mainImg = None
                postType = 'unknown'

                if not msg and onlyMsg:
                    continue

                subattachments = []
                if 'attachments' in data:
                    data2 = data['attachments']['data'][0]

                    mainImg = data2.get("media", {}).get("image", {}).get("src")
                    postType =  data2.get('type', 'article')

                    if "subattachments" in data2:
                        for data3 in data2["subattachments"]['data']:
                            title = data3.get('title')
                            subattachmentType = data3.get('type')
                            url = data3.get('url')
                            image = data3.get(
                                "media", {}).get("image", {}).get("src")

                            subattachments.append(
                                Subattachment(
                                    title, subattachmentType, image, url))

                addToFpList = False
                for t in articleTypes:
                    if t in postType:
                        addToFpList = True

                if addToFpList:
                    fpList.append(
                        FanPage(
                            id, createdTime, msg, mainImg, postType, link, 
                            subattachments))

                    if len(fpList) == instance.limit:
                        break
            
        context.update({
            'fpList': fpList,
        })
        
        return context
        
class FacebookPhotoPlugin(CMSPluginBase):
    model = FacebookPhoto
    module = _("Zephyrus Facebook")
    name = _("Facebook Fan Photo")
    render_template = zephyrusSettings.ZEPHYRUS_FACEBOOK_PHOTO_DEFAULT_TEMPLATE

    def get_render_template(self, context, instance, placeholder):
        return select_template([
            instance.renderTemplate,
            zephyrusSettings.ZEPHYRUS_FACEBOOK_PHOTO_DEFAULT_TEMPLATE,
        ])

    def render(self, context, instance, placeholder):
        accessToken = '%s|%s' % (
            settings.SOCIAL_AUTH_FACEBOOK_KEY, 
            settings.SOCIAL_AUTH_FACEBOOK_SECRET
        )
        
        albumId = None
        fanPageId = getFanPageId(accessToken, instance.url)
        if 'album_id=' in instance.url:
            index = instance.url.index('album_id=') + len('album_id=')
            albumId = instance.url[index:]
        else:
            if not fanPageId:
                # ��}�ݲŦX���T�榡
                context.update({
                    'error': _('Url must conform correct format, '
                               'EX: https://www.facebook.com/pg/xxx/photos/'
                               '?tab=album&album_id=xxx'),
                })
                return context

        if albumId:
            query = "?fields=photos.limit(100){name,images,link}"
            req = requests.get(
                'https://graph.facebook.com/v2.8/%s/%s&access_token=%s' % (
                albumId, query, accessToken)
                )
        else:
            query = ("photos/uploaded?fields=images,name,link&limit=%d" % 
                     instance.limit)
            if not fanPageId:
                # ��}�ݲŦX���T�榡
                context.update({
                    'error': _('Url must conform correct format, '
                               'EX: https://www.facebook.com/xxx/'),
                })
                return context
            req = requests.get(
                'https://graph.facebook.com/v2.8/%s/%s&access_token=%s' % (
	            fanPageId, query, accessToken)
            )     
        
        text = json.loads(req.text)
        
        if 'photos' in text and 'data' in text['photos']:
            content = text['photos']['data']
        elif 'data' in text:
            content = text['data']
        else:
            # �j�M�����ï���
            context.update({
                'error': _("Album data doesn't be searched"),
            })
            return context
                
        
        # create objects
        photoList = []
        for data in content:
            name = None
            url = None
            link = None
            if not 'images' in data:
                continue
            for data2 in data['images']:
                if 'source' in data2:
                    url = data2['source']
                    break
            if 'name' in data:
                name = mark_safe(data['name'].replace('\n', '<br />'))
            if 'link' in data:
                link = data['link']
            photoList.append(Photo(name, url, link))
            if len(photoList) == instance.limit:
                break
        
        context.update({
            'photoList': photoList,
        })
        
        return context

plugin_pool.register_plugin(FacebookFanPlugin)
plugin_pool.register_plugin(FacebookPhotoPlugin)