#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: create_zip.py 10818 2018-03-05 08:44:31Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2018-03-05 16:44:31 +0800 (週一, 05 三月 2018) $
# $Revision: 10818 $

import os
import shutil
import zipfile

from django.core.management.base import BaseCommand, CommandError

class Command(BaseCommand):

    help = 'Cut template.zip to meta data zip and body zip with ups as name.'
    
    def add_arguments(self, parser):
        parser.add_argument('source', type=str, help="source folder")
        parser.add_argument('dest', type=str, help="destination folder")
        
    def handle(self, *args, **options):
        source = options["source"]
        dest = options["dest"]
        
        fileList = os.listdir(source)
        
        for f in fileList:
            print(f)
            templatePath = os.path.join(source, f)
            
            tempPath = os.path.join(dest, "temp")
            
            zipPath = os.path.join(dest, "temp", "template.zip")
            
            metaDir = os.path.join(dest, "metadata")
            bodyDir = os.path.join(dest, "body")
            
            metadataPath = os.path.join(metaDir, f)
            bodyPath = os.path.join(bodyDir, f)
            
            if not os.path.isdir(tempPath):
                os.mkdir(tempPath)
            if not os.path.isdir(metaDir):
                os.mkdir(metaDir)
            if not os.path.isdir(bodyDir):
                os.mkdir(bodyDir)
                              
            zf = zipfile.ZipFile(templatePath, mode='r')
            zf.extractall(tempPath)
            zf.close()
            
            shutil.move(zipPath, bodyPath)
            
            zf = zipfile.ZipFile(metadataPath, mode='w')
            for root, folders, files in os.walk(tempPath):
                for sfile in files:
                    
                    aFile = os.path.join(root, sfile)
                    dFile = os.path.join(root[len(tempPath) + 1:], sfile)
                    zf.write(aFile, dFile)
            zf.close()
            
            shutil.rmtree(tempPath)
            