#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: ConfigureTest.py 10406 2017-10-24 10:12:27Z David $
#
# Copyright (c) 2015 Nuwa Information Co., Ltd, and individual contributors.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
#   1. Redistributions of source code must retain the above copyright notice,
#      this list of conditions and the following disclaimer.
#
#   2. Redistributions in binary form must reproduce the above copyright
#      notice, this list of conditions and the following disclaimer in the
#      documentation and/or other materials provided with the distribution.
#
#   3. Neither the name of Nuwa Information nor the names of its contributors
#      may be used to endorse or promote products derived from this software
#      without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# $Author: David $ (last)
# $Date: 2017-10-24 18:12:27 +0800 (Tue, 24 Oct 2017) $
# $Revision: 10406 $
"""
Test Configure module.
"""

import unittest
import os

from Iuppiter import Configure

class ConfigureTest(unittest.TestCase):
    """
    Test case for config setting file
    """

    curdir = os.getcwd()
    fileDir = os.path.abspath(os.path.dirname(__file__))
    
    def setUp(self):
        os.chdir(self.fileDir)   
    
    def testGetSettings(self):
        """
        test for getSettings function
        """
        curdir = os.getcwd()
        fileDir = os.path.abspath(os.path.dirname(__file__))
        testDataFile = os.path.join(fileDir, 'TestData')
        os.chdir(fileDir)
        
        def inSameDir():
            if not os.path.exists('settings.py'):
                file = open('settings.py', 'w+')
                file.close()
            
            setting = Configure.getSettings()
            self.assertEqual(setting, 'tests.settings')
            
            if os.path.exists('settings.py'):
                os.remove('settings.py')
            
        def inParentDir():
            baseDir = os.path.abspath(
                        os.path.join(testDataFile, 'configure_test1', 
                                    'configure_test2'))
            parentDir = os.path.abspath(
                            os.path.join(testDataFile, 'configure_test1'))
                    
            os.chdir(parentDir)
            if not os.path.exists('settings.py'):
                file = open('settings.py', 'w+')
                file.close()
                
            os.chdir(baseDir)
            setting = Configure.getSettings()
            self.assertEqual(setting, 'configure_test1.settings')
            
            os.chdir(parentDir)
            if os.path.exists('settings.py'):
                os.remove('settings.py')
        
        def inUpTwoLevelDir():
            baseDir = os.path.abspath(
                            os.path.join(testDataFile, 'configure_test1', 
                                   'configure_test2', 'configure_test3'))
            upTwoLevelDir = os.path.abspath(
                                os.path.join(testDataFile, 'configure_test1'))
                    
            os.chdir(upTwoLevelDir)
            if not os.path.exists('settings.py'):
                file = open('settings.py', 'w+')
                file.close()
                
            os.chdir(baseDir)
            setting = Configure.getSettings()
            self.assertEqual(setting, 'configure_test1.settings')
            
            os.chdir(upTwoLevelDir)
            if os.path.exists('settings.py'):
                os.remove('settings.py')
        
        def inSubDir():
            baseDir = os.path.abspath(
                        os.path.join(testDataFile, 'configure_test1'))
            subDir = os.path.abspath(
                        os.path.join(testDataFile, 'configure_test1', 
                                   'configure_test2'))
            
            os.chdir(subDir)
            if not os.path.exists('settings.py'):
                file = open('settings.py', 'w+')
                file.close()
                
            os.chdir(baseDir)
            setting = Configure.getSettings()
            self.assertEqual(setting, 'configure_test2.settings')
            
            os.chdir(subDir)
            if os.path.exists('settings.py'):
                os.remove('settings.py')
                        
        def inDownTwoLevelDir():
            baseDir = os.path.abspath(
                        os.path.join(testDataFile, 'configure_test1'))
            subDir = os.path.abspath(
                        os.path.join(testDataFile, 'configure_test1', 
                                   'configure_test2', 'configure_test3'))
            
            os.chdir(subDir)
            if not os.path.exists('settings.py'):
                file = open('settings.py', 'w+')
                file.close()
                
            os.chdir(baseDir)
            setting = Configure.getSettings()
            self.assertEqual(setting, 'configure_test2.configure_test3.settings')
            
            os.chdir(subDir)
            if os.path.exists('settings.py'):
                os.remove('settings.py')    

        inSameDir()
        inParentDir()
        inUpTwoLevelDir()
        inSubDir()
        inDownTwoLevelDir()
        
    def tearDown(self):
        os.chdir(self.curdir)

if __name__ == '__main__':
    unittest.main()
