#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: DistUtilTest.py 9687 2016-06-23 07:23:02Z Judy $
#
# Copyright (c) 2015 Nuwa Information Co., Ltd, and individual contributors.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
#   1. Redistributions of source code must retain the above copyright notice,
#      this list of conditions and the following disclaimer.
#
#   2. Redistributions in binary form must reproduce the above copyright
#      notice, this list of conditions and the following disclaimer in the
#      documentation and/or other materials provided with the distribution.
#
#   3. Neither the name of Nuwa Information nor the names of its contributors
#      may be used to endorse or promote products derived from this software
#      without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# $Author: Judy $ (last)
# $Date: 2016-06-23 15:23:02 +0800 (Thu, 23 Jun 2016) $
# $Revision: 9687 $
# from setup import extraRequirements

"""
Test all DistUDistUtil
"""

import unittest
import os
import sys
import platform

from Iuppiter import DistUtil

class DistUtilTest(unittest.TestCase):  
    
    def testGetScript(self):
        pythonDir = os.path.dirname(sys.executable)
        pythonScriptDir = os.path.join(pythonDir, "Scripts")
        
        scriptDir = pythonDir
        if os.path.exists(pythonScriptDir):
            scriptDir = pythonScriptDir              
        
        if platform.system() == "Linux":   
            script2Location = os.path.join(scriptDir, "script2")
        else:
            script2Location = os.path.join(scriptDir, "script2.exe")        
        try:
            with open(script2Location, 'w+'):
                if os.path.exists(script2Location):
                    script2 = DistUtil.getScript("script2")
                    self.assertEqual(script2Location, script2)
        finally:
            if os.path.exists(script2Location):
                os.remove(script2Location)
        
        script3 = DistUtil.getScript("script3")
        self.assertEqual(None, script3)   
        
    def testGetRequirement(self):
        rootDir = os.path.dirname(__file__)
        requirementFile = os.path.join(rootDir, "TestData", "REQUIREMENTS.txt")
        
        requirements = DistUtil.getRequirements(requirementFile)
        _requires = []
        _extraRequires = []
        
        requires = ['Django==1.8.2', 'decorator==4.0.2', 
                    'logilab-astng==0.24.3', 'lxml==3.4.0', 
                    'APScheduler==2.0.3', 'threadpool==1.2.7']
        extraRequires = ['http://test1', 'https://test2', 'git+http://test3',
                         'hg+https://test4', 'svn+https://test5', 
                         'bzr+https://test6']
        
        if platform.system() == 'Linux':            
            for r in requirements[0]:
                if r != '\r':
                    r = r.rstrip('\r')
                    r = r.strip(' ')
                    _requires.append(r)
            for r in requirements[1]:
                if r != '\r':
                    r = r.rstrip('\r')
                    r = r.strip(' ')
                    _extraRequires.append(r)
        else:
            _requires = requirements[0]
            _extraRequires = requirements[1]
        
        self.assertEqual(_requires, requires)
        self.assertEqual(_extraRequires, extraRequires)  
        
if __name__ == '__main__':
    unittest.main()
