#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: __init__.py 9659 2016-05-04 09:55:22Z Judy $
#
# Copyright (c) 2016 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Judy $
# $Date: 2016-05-04 17:55:22 +0800 (週三, 04 五月 2016) $
# $Revision: 9659 $
"""
Celery tasks which should be run at cloud worker.
"""

import os
import time
import datetime
import logging
import inspect

from celery import task

try:
    import lzma # Python 3.3
except ImportError:
    import pylzma as lzma

from .. import HTTP_METHOD
from .. import Config, Request

logger = logging.getLogger(__name__)

@task
def send(request, engine):
    """
    Send job implementation.
    
    @param request AyncRequest instance.
    @param engine Browser implementation engine.
    @return AyncResponse.
    """
    method = request.method
    if not method:
        method = 'get'
        
    kws = dict([(arg, getattr(request, arg)) 
                for arg in inspect.getargspec(Request.__init__)[0]
                if hasattr(request, arg)])
    kws.pop('url', None)
    kws.pop('method', None)
    
    func = HTTP_METHOD.get(method, None)
    if func:
        response = func(request.url, engine=engine, async=False, **kws)
    else:
        raise NotImplementedError('Not implemented method: %s' % method)

    response.content = lzma.compress(response.content)
    response.snapshot = lzma.compress(response.snapshot)
    
    return response
