#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: configure.py 105 2016-12-24 02:07:51Z Lavender $
#
# Copyright (c) 2016 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2016-12-24 10:07:51 +0800 (週六, 24 十二月 2016) $
# $Revision: 105 $

import os
import datetime

from django.core.management.base import BaseCommand, CommandError
from django.template.loader import get_template
from django.template import Context
from django.core.management import call_command

class Command(BaseCommand):
    
    help = 'Create project app and add our file header.'
    
    def add_arguments(self, parser):
        parser.add_argument('name', type=str, help="App name")

    def handle(self, *args, **options):
        name = options['name']

        call_command('startapp', name)

        # add header
        context = Context({
            "year": datetime.date.today().year, 
        })
        temp = get_template('scaffold/HeaderTemplate.py')
        header = temp.render(context)

        for root, dirs, files in os.walk(os.path.join(name)):
            for f in files:
                path = os.path.join(root, f)
                if f == 'tests.py':
                    os.remove(path)
                    continue
                
                with open(path, 'r') as f:
                    content = f.read()
                content = header + content
                with open(path, 'w') as f:
                    f.write(content)
                    