#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: views.py 11945 2020-02-21 11:10:48Z Lavender $
#
# Copyright (c) 2018 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License, 
# you may not use this file except in compliance with the License. 
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and 
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2020-02-21 19:10:48 +0800 (週五, 21 二月 2020) $
# $Revision: 11945 $

from django.http import HttpResponse
from django.views.decorators.csrf import csrf_exempt
from Iuppiter.Logging import createLogger 

logger = createLogger(__name__)

# url(r'^log/', partail(Iuno.views.sendLog, title="TemplateShop") name='sendLog'),
 
@csrf_exempt
def sendLog(request, title):
    try:
        level = request.POST.get("level", 'info').upper()
        
        levelFunc = {
            'CRITICAL': logger.critical,
            'ERROR': logger.error,
            'WARNING': logger.warning,
            'INFO': logger.info,
            'DEBUG': logger.debug,
        }
        if level in levelFunc:
            levelFunc[level]("%s Send log: %s" % (title, request.POST,))
        else:
            raise KeyError("Not level name %s" % level)
    except Exception as e:
        logger.error("%s Send log error: %s %s" % (
            title, request.POST, str(e)))
        
    return HttpResponse("success")
    