/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jslint4java;

import com.googlecode.jslint4java.Issue;
import com.googlecode.jslint4java.JSFunction;
import com.googlecode.jslint4java.JSLintResult;
import com.googlecode.jslint4java.Option;
import com.googlecode.jslint4java.OptionParser;
import com.googlecode.jslint4java.Util;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.UniqueTag;

public class JSLint {
    private static final String DEFAULT_INDENT = "4";
    private static final String DEFAULT_MAXERR = "50";
    private final Map<Option, Object> options = new EnumMap<Option, Object>(Option.class);
    private final ContextFactory contextFactory;
    private final Function lintFunc;

    JSLint(ContextFactory contextFactory, Function lintFunc) {
        this.contextFactory = contextFactory;
        this.lintFunc = lintFunc;
    }

    public void addOption(Option o) {
        this.options.put(o, Boolean.TRUE);
    }

    public void addOption(Option o, String arg) {
        OptionParser optionParser = new OptionParser();
        this.options.put(o, optionParser.parse(o.getType(), arg));
    }

    private void applyDefaultOptions() {
        if (!this.options.containsKey((Object)Option.INDENT)) {
            this.addOption(Option.INDENT, DEFAULT_INDENT);
        }
        if (!this.options.containsKey((Object)Option.MAXERR)) {
            this.addOption(Option.MAXERR, DEFAULT_MAXERR);
        }
    }

    private JSLintResult buildResults(final String systemId, final long startNanos, final long endNanos) {
        return (JSLintResult)this.contextFactory.call(new ContextAction(){

            @Override
            public Object run(Context cx) {
                Object properties;
                JSLintResult.ResultBuilder b = new JSLintResult.ResultBuilder(systemId);
                b.duration(TimeUnit.NANOSECONDS.toMillis(endNanos - startNanos));
                for (Issue issue : JSLint.this.readErrors(systemId)) {
                    b.addIssue(issue);
                }
                b.report(JSLint.this.callReport(false));
                Object o = JSLint.this.lintFunc.get("data", (Scriptable)JSLint.this.lintFunc);
                if (o != UniqueTag.NOT_FOUND) {
                    Function reportFunc = (Function)o;
                    Scriptable data = (Scriptable)reportFunc.call(cx, JSLint.this.lintFunc, null, Context.emptyArgs);
                    for (String global : Util.listValueOfType("global", String.class, data)) {
                        b.addGlobal(global);
                    }
                    b.json(Util.booleanValue("json", data));
                    for (JSFunction f : Util.listValue("functions", data, new JSFunctionConverter())) {
                        b.addFunction(f);
                    }
                }
                if ((properties = JSLint.this.lintFunc.get("property", (Scriptable)JSLint.this.lintFunc)) != UniqueTag.NOT_FOUND) {
                    for (Object id : ScriptableObject.getPropertyIds((Scriptable)properties)) {
                        b.addProperty(id.toString());
                    }
                }
                return b.build();
            }
        });
    }

    private String callReport(final boolean errorsOnly) {
        return (String)this.contextFactory.call(new ContextAction(){

            @Override
            public Object run(Context cx) {
                Function fn = null;
                Object value = null;
                StringBuilder sb = new StringBuilder();
                value = JSLint.this.lintFunc.get("data", (Scriptable)JSLint.this.lintFunc);
                if (value == UniqueTag.NOT_FOUND) {
                    return "";
                }
                fn = (Function)value;
                Object data = fn.call(cx, JSLint.this.lintFunc, null, Context.emptyArgs);
                value = JSLint.this.lintFunc.get("error_report", (Scriptable)JSLint.this.lintFunc);
                if (value != UniqueTag.NOT_FOUND) {
                    fn = (Function)value;
                    sb.append(fn.call(cx, JSLint.this.lintFunc, null, new Object[]{data}));
                }
                if (!errorsOnly && (value = JSLint.this.lintFunc.get("report", (Scriptable)JSLint.this.lintFunc)) != UniqueTag.NOT_FOUND) {
                    fn = (Function)value;
                    sb.append(fn.call(cx, JSLint.this.lintFunc, null, new Object[]{data}));
                }
                return sb.toString();
            }
        });
    }

    private void doLint(final String javaScript) {
        this.contextFactory.call(new ContextAction(){

            @Override
            public Object run(Context cx) {
                String src = javaScript == null ? "" : javaScript;
                Object[] args = new Object[]{src, JSLint.this.optionsAsJavaScriptObject()};
                JSLint.this.lintFunc.call(cx, JSLint.this.lintFunc, null, args);
                return null;
            }
        });
    }

    public String getEdition() {
        return (String)this.lintFunc.get("edition", (Scriptable)this.lintFunc);
    }

    public JSLintResult lint(String systemId, Reader reader) throws IOException {
        return this.lint(systemId, Util.readerToString(reader));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSLintResult lint(String systemId, String javaScript) {
        JSLint jSLint = this;
        synchronized (jSLint) {
            long before = System.nanoTime();
            this.doLint(javaScript);
            long after = System.nanoTime();
            return this.buildResults(systemId, before, after);
        }
    }

    private Scriptable optionsAsJavaScriptObject() {
        return (Scriptable)this.contextFactory.call(new ContextAction(){

            @Override
            public Object run(Context cx) {
                JSLint.this.applyDefaultOptions();
                Scriptable opts = cx.newObject(JSLint.this.lintFunc);
                for (Map.Entry entry : JSLint.this.options.entrySet()) {
                    String key = ((Option)((Object)entry.getKey())).getLowerName();
                    Object value = Util.javaToJS(entry.getValue(), opts);
                    opts.put(key, opts, value);
                }
                return opts;
            }
        });
    }

    private List<Issue> readErrors(String systemId) {
        ArrayList<Issue> issues = new ArrayList<Issue>();
        Scriptable errors = (Scriptable)this.lintFunc.get("errors", (Scriptable)this.lintFunc);
        int count = Util.intValue("length", errors);
        for (int i = 0; i < count; ++i) {
            Scriptable err = (Scriptable)errors.get(i, errors);
            if (err == null) continue;
            issues.add(Issue.IssueBuilder.fromJavaScript(systemId, err));
        }
        return issues;
    }

    public String report(String javaScript) {
        return this.report(javaScript, false);
    }

    public String report(String javaScript, boolean errorsOnly) {
        this.doLint(javaScript);
        return this.callReport(errorsOnly);
    }

    public void resetOptions() {
        this.options.clear();
    }

    private static final class JSFunctionConverter
    implements Util.Converter<JSFunction> {
        private JSFunctionConverter() {
        }

        @Override
        public JSFunction convert(Object obj) {
            Scriptable scope = (Scriptable)obj;
            String name = Util.stringValue("name", scope);
            int line = Util.intValue("line", scope);
            JSFunction.Builder b = new JSFunction.Builder(name, line);
            b.last(Util.intValue("last", scope));
            for (String param : Util.listValueOfType("parameter", String.class, scope)) {
                b.addParam(param);
            }
            for (String closure : Util.listValueOfType("closure", String.class, scope)) {
                b.addClosure(closure);
            }
            for (String var : Util.listValueOfType("var", String.class, scope)) {
                b.addVar(var);
            }
            for (String exception : Util.listValueOfType("exception", String.class, scope)) {
                b.addException(exception);
            }
            for (String outer : Util.listValueOfType("outer", String.class, scope)) {
                b.addOuter(outer);
            }
            for (String unused : Util.listValueOfType("unused", String.class, scope)) {
                b.addUnused(unused);
            }
            for (String global : Util.listValueOfType("global", String.class, scope)) {
                b.addGlobal(global);
            }
            for (String label : Util.listValueOfType("label", String.class, scope)) {
                b.addLabel(label);
            }
            return b.build();
        }
    }
}

