# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
from django.conf import settings


class Migration(migrations.Migration):

    dependencies = [
        ('newsletter', '__first__'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='App',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=255, verbose_name='\u540d\u7a31')),
                ('createdTime', models.DateTimeField(auto_now_add=True, verbose_name='\u5efa\u7acb\u6642\u9593')),
            ],
            options={
                'verbose_name': 'app',
                'verbose_name_plural': 'apps',
            },
        ),
        migrations.CreateModel(
            name='Group',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=255, verbose_name='\u540d\u7a31')),
                ('createdTime', models.DateTimeField(auto_now_add=True, verbose_name='\u5efa\u7acb\u6642\u9593')),
                ('newsletters', models.ManyToManyField(to='newsletter.Newsletter', null=True, verbose_name='\u96fb\u5b50\u5831', blank=True)),
            ],
            options={
                'verbose_name': '\u7fa4\u7d44',
                'verbose_name_plural': '\u7fa4\u7d44',
            },
        ),
        migrations.CreateModel(
            name='GroupMappingTable',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('conditionType', models.IntegerField(default=0, help_text='\u8acb\u9078\u64c7\u4e00\u7a2e\u689d\u4ef6\u985e\u578b\uff0c\u9810\u8a2d\u662f\u95dc\u9375\u5b57\u3002', verbose_name='\u689d\u4ef6\u985e\u578b', choices=[(0, '\u95dc\u9375\u5b57'), (1, '\u6b63\u898f\u8868\u793a\u6cd5')])),
                ('condition', models.TextField(max_length=1024, verbose_name='\u6b63\u898f\u8868\u793a\u6cd5')),
                ('group', models.CharField(max_length=255, null=True, verbose_name='\u7fa4\u7d44\u540d\u7a31', blank=True)),
                ('app', models.ForeignKey(verbose_name='App', to='integration.App', help_text='\u8acb\u9078\u64c7\u4e00\u500bapp\u3002')),
                ('current', models.ForeignKey(verbose_name='Current Group', to='integration.Group', null=True)),
            ],
            options={
                'verbose_name': '\u7fa4\u7d44\u5c0d\u61c9\u8868',
                'verbose_name_plural': '\u7fa4\u7d44\u5c0d\u61c9\u8868',
            },
        ),
        migrations.AddField(
            model_name='app',
            name='groups',
            field=models.ManyToManyField(related_name='groups', null=True, to='integration.Group'),
        ),
        migrations.AddField(
            model_name='app',
            name='user',
            field=models.ForeignKey(verbose_name='\u4f7f\u7528\u8005', to=settings.AUTH_USER_MODEL),
        ),
    ]
