#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: models.py 10455 2017-11-07 09:08:16Z David $
#
# Copyright (c) 2013 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: David $
# $Date: 2017-11-07 17:08:16 +0800 (Tue, 07 Nov 2017) $
# $Revision: 10455 $

from Theophrastus.models import Newsletter, Contact
from django.db import models
from django.utils.translation import ugettext_lazy as _

class Header(models.Model):

    content = models.TextField(
        _('Header content'), blank=True, null=True,
        help_text=_('Custom your header content.'))

    def __unicode__(self):
        return _('Header %s') % str(self.id)

    class Meta:
        verbose_name = _('Header')
        verbose_name_plural = _('Headers')

class Footer(models.Model):

    content = models.TextField(
        _('Footer content'), blank=True, null=True,
        help_text=_('Custom your footer content.'))

    def __unicode__(self):
        return _('Footer %s') % str(self.id)

    class Meta:
        verbose_name = _('Footer')
        verbose_name_plural = _('Footers')

class ErrorMessage(models.Model):

    message =  models.CharField(max_length=2048, blank=True, null=True)

    newsletter = models.ForeignKey(Newsletter, verbose_name=_('newsletter'))

    contact = models.ForeignKey(Contact, verbose_name=_('contact'))