#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: start_app.py 11244 2018-10-10 15:19:58Z Lavender $
#
# Copyright (c) 2016 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2018-10-11 00:19:58 +0900 (週四, 11 十月 2018) $
# $Revision: 11244 $

import os
import sys
import hashlib
import platform
import six

from django.core.management.base import BaseCommand, CommandError
from django.template.loader import get_template
from django.template import Context

from Iuppiter.Logging import createLogger

logger = createLogger(__name__)

def toBytes(s):
    return s if six.PY2 else s.encode()

class Command(BaseCommand):
    
    help = 'Add cron job for the project.'
    
    def add_arguments(self, parser):
        parser.add_argument('command', type=str, help="Command")
        parser.add_argument('time', type=str, help="Time")

    def handle(self, *args, **options):
        command = options['command']
        time = options['time']
        
        jobName = hashlib.md5(
                    toBytes("%s %s" % (command, time))).hexdigest()
        
        temp = get_template("deploy/Cron.sh")
        c = Context({
            "command": command,
            "time": time,
            "jobName": jobName,
        })
        
        shell = temp.render(c)
        
        with open("%s.sh" % jobName, 'w') as f:
            f.write(shell)
        
        sysStr = platform.system()
        if sysStr == "Linux":
            result = os.system("chmod +x %s.sh" % jobName)
            result = os.system("./%s.sh" % jobName)
            
            if result == 0:
                logger.info(
                    "Success set '%s' '%s' to cronjob." %(command, time))
            else:
                logger.error("Error set '%s' '%s' to cronjob." %(command, time))
        else:
            pass
            
        os.remove("%s.sh" % jobName)


            
                    