#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: ZephyrusSettings.py 13367 2021-12-24 04:53:31Z Mint $
#
# Copyright (c) 2015 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Mint $ (last)
# $Date: 2021-12-24 12:53:31 +0800 (週五, 24 十二月 2021) $
# $Revision: 13367 $
"""
Default settings for this project if it can't import settings.
"""

# Populate it to here as default settings.
#from django.conf.global_settings import *

# These settings is useless, these values only used in test environment.
# You should set these values in your projects settings.py.

import os

gettext = lambda s: s

BASE_DIR = os.path.dirname(os.path.abspath(__file__))

SECRET_KEY = '-1evj*zt(60#q+u=-iy4sc7%f_a&tmrtox%salcf4a!^(49d^l'

DEBUG = True
TEMPLATE_DEBUG = DEBUG

TEST_DIR_PATH = os.path.join(BASE_DIR, 'tests', 'boilerplate', "TestHtml")
ERROR_DIR_PATH = os.path.join(BASE_DIR, 'tests', 'boilerplate', "BackupHtml")

if not os.path.exists(TEST_DIR_PATH):
    os.mkdir(TEST_DIR_PATH)
    
if not os.path.exists(ERROR_DIR_PATH):
    os.mkdir(ERROR_DIR_PATH)

DATABASES = {
    'default': {
        'NAME': 'Zephyrus.db',
        'ENGINE': 'django.db.backends.sqlite3',
        'USER': '',
        'PASSWORD': '',
        'OPTIONS': {
            #'timeout': 60,
            #'isolation_level': None,
        },
    }
}

LANGUAGE_CODE = 'en'

TIME_ZONE = 'Asia/Taipei'

USE_I18N = True

USE_L10N = True

USE_TZ = True

LANGUAGES = (
    ('en', gettext('en')),
)

CMS_LANGUAGES = {
    'default': {
        'public': True,
        'hide_untranslated': False,
        'redirect_on_fallback': True,
    },
    1: [
        {
            'public': True,
            'code': 'en',
            'hide_untranslated': False,
            'name': gettext('en'),
            'redirect_on_fallback': True,
        },
    ],
}

STATIC_URL = '/static/'
if DEBUG:    
    STATICFILES_DIRS = (
        os.path.join(BASE_DIR, 'tests', 'static'),
    )
else:
    STATIC_ROOT = os.path.join(BASE_DIR, 'tests', 'static')

if not os.path.exists(STATICFILES_DIRS[0]):
    os.mkdir(STATICFILES_DIRS[0])    
    
TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [os.path.join(BASE_DIR, 'tests', 'templates'),],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
                
                'sekizai.context_processors.sekizai',
                'cms.context_processors.cms_settings',
            ],
        },
    },
]

if not os.path.exists(TEMPLATES[0]['DIRS'][0]):
    os.mkdir(TEMPLATES[0]['DIRS'][0])    

def getCMSTemplates():
    templates = []
    
    path = TEMPLATES[0]['DIRS'][0]
    index = None
            
    for template in os.listdir(path):
        if template.lower() == 'index.html':
            index = template
            continue
        templates.append((template, template))
    
    if index:
        return [(index, index),] + templates
    else:
        return templates

CMS_TEMPLATES = getCMSTemplates()

MIDDLEWARE = (
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.auth.middleware.SessionAuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
    'django.middleware.security.SecurityMiddleware',
)

INSTALLED_APPS = (
    #'djangocms_admin_style',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.admin',
    'django.contrib.sites',
    'django.contrib.sitemaps',
    'django.contrib.staticfiles',
    'django.contrib.messages',
    'cms',
    'menus',
    'sekizai',
    'treebeard',
    'djangocms_text_ckeditor',
    'djangocms_style',
    'djangocms_column',
    'filer',
    'easy_thumbnails',
    # 'cmsplugin_filer_image',
    'djangocms_googlemap',
    # 'djangocms_inherit',
    'djangocms_link',
    'djangocms_picture',
    
    'Iuppiter.extension',
    'Iuppiter.test',
    'Zephyrus.tests',
    'Zephyrus.boilerplate',  
    'Zephyrus.facebook',
)

SITE_ID = 1

