#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: get_template.py 11677 2019-08-16 00:30:37Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2019-08-16 08:30:37 +0800 (週五, 16 八月 2019) $
# $Revision: 11677 $

import os
import shutil
import traceback

from django.core.management.base import BaseCommand, CommandError

from Zephyrus.boilerplate.management.commands import (
    TEMPLATES_DIR_PATH, STATIC_DIR_PATH, IMAGES_DIR_PATH, ROOT_DIR_PATH)
from Zephyrus.boilerplate.management.commands import createLogger

logger = createLogger(__name__, "GetTemplate.log")

class Command(BaseCommand):

    help = 'Copy html to templates and copy static files to static.'
    args = '<destination folder>'
    
    def add_arguments(self, parser):
        parser.add_argument('path', type=str, help="template folder")

    def handle(self, *args, **options):
        try:
            
            path = options['path']

            try:
                shutil.rmtree(TEMPLATES_DIR_PATH)
                logger.info("Remove Temeplates folder.")
            except Exception as e:
                logger.info("Temeplates folder is not exist.")
                os.mkdir(TEMPLATES_DIR_PATH)
            else:
                os.mkdir(TEMPLATES_DIR_PATH)
                logger.info("Create Temeplates folder.")

            try:
                shutil.rmtree(STATIC_DIR_PATH)
                logger.info("Remove static folder.")
            except Exception as e:
                logger.info("Static folder is not exist.")
                os.mkdir(STATIC_DIR_PATH)
            else:
                os.mkdir(STATIC_DIR_PATH)
                logger.info("Create static folder.")
                
            try:
                shutil.rmtree(IMAGES_DIR_PATH)
                logger.info("Remove images folder.")
            except Exception as e:
                logger.info("Images folder is not exist.")
                

            logger.info("-----Start copy templates-----")
            
            if os.path.isdir(os.path.join(path, 'images')):
                imgPath = os.path.join(path, 'images')
                shutil.copytree(imgPath, IMAGES_DIR_PATH)
                logger.info("Copy images folder to root.")

            copyHtml = False
            templateRootPath = None 
            for root, dirs, files in os.walk(path):
                if 'info.json' in files:
                    jsonPath = os.path.join(root, 'info.json')           
                    jsonDst = os.path.join(ROOT_DIR_PATH, 'info.json')
                    shutil.copyfile(jsonPath, jsonDst)
                    logger.info('Copy %s to root.' % 'info.json')

                if "index.html" in files or "Index.html" in files:
                    copyHtml = True
                else:
                    for f in files:
                        if f.endswith('.html'):
                            copyHtml = True
                            logger.info(
                                ("WARNING: '%s' not have 'index.html', "
                                 "but have %s") % (path, f))
                
                if copyHtml:
                    templateRootPath = root
                    break
                    
            if not copyHtml:
                logger.error("'%s' not have html file" % path)
                raise RuntimeError("'%s' not have html file" % path)
            else:
                for root, dirs, files in os.walk(templateRootPath):
                    if path.endswith('/') or path.endswith('\\'):
                        relatedPath = root.replace(path, '')
                    else:
                        # 去掉第一個 / or \
                        relatedPath = root.replace(path, '')[1:]
                    
                    for fileName in files:
                        filePath = os.path.join(root, fileName)
                        
                        if fileName.endswith('.html'):
                            dstDirPath = os.path.join(
                                TEMPLATES_DIR_PATH, relatedPath)
                            logger.info(
                                'Copy %s to templates folder.' % fileName)
                        else:
                            dstDirPath = os.path.join(
                                STATIC_DIR_PATH, relatedPath)
                            logger.info('Copy %s to static folder.' % fileName)
                            
                        dirList = [dstDirPath,]
                            
                        dirPath = dstDirPath
                        while True:
                            dirPath = os.path.dirname(dirPath)
                            if not os.path.exists(dirPath):
                                dirList.append(dirPath)
                            else:
                                break
                        
                        dirList.reverse()
                        for d in dirList:
                            if not os.path.isdir(d):
                                os.mkdir(d)
                        dst =  os.path.join(dstDirPath, fileName)
                        shutil.copyfile(filePath, dst)
                        
            logger.info('-----All OK!-----')
        except Exception as e:
            logger.error("get_template error:%s" % e)
            with open('./AllError.log', 'w+') as log:
                log.write(traceback.format_exc())
            raise

        