#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: models.py 11661 2019-07-21 13:46:06Z Trista $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Trista $
# $Date: 2019-07-21 21:46:06 +0800 (週日, 21 七月 2019) $
# $Revision: 11661 $


from django.db import models

from django.utils.translation import ugettext_lazy as _
from django.core.validators import MaxValueValidator

from cms.models import CMSPlugin

# This might need to be adjusted to fit in any project
from Zephyrus.instagram import settings

# Create your models here.

class InstagramPhoto(CMSPlugin):
    userUrl = models.URLField()
    renderTemplate = models.CharField(
        _('IG Photo Template'), max_length=150, blank=True,
        choices=settings.INSTAGRAM_PHOTO_TEMPLATES,
        default=settings.INSTAGRAM_PHOTO_DEFAULT_TEMPLATE,
    )
    limit = models.PositiveIntegerField(default=12,
        validators=[MaxValueValidator(12),])

    class Meta:
        verbose_name = _("Instagram Photo")
        verbose_name_plural = _("Instagram Photo")
