#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: __init__.py 11979 2020-03-18 04:52:03Z Trista $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Trista $
# $Date: 2020-03-18 12:52:03 +0800 (週三, 18 三月 2020) $
# $Revision: 11979 $

from django.conf import settings as _settings
from django.utils.translation import ugettext_lazy as _

class settings(object):
    ZEPHYRUS_BLOG_MAYLIKE_DEFAULT_TEMPLATE = \
        "blog_extension/Default.html"

    ZEPHYRUS_BLOG_DATE_DEFAULT_TEMPLATE = \
        "blog_extension/Date.html"

    ZEPHYRUS_BLOG_MAYLIKE_TEMPLATES = [
        (ZEPHYRUS_BLOG_MAYLIKE_DEFAULT_TEMPLATE, _("Default")),
    ]
    ZEPHYRUS_BLOG_DATE_TEMPLATES = [
        (ZEPHYRUS_BLOG_DATE_DEFAULT_TEMPLATE, _("Default")),
    ]

    if hasattr(_settings, 'ZEPHYRUS_BLOG_MAYLIKE_TEMPLATES'):
        for ele in _settings.ZEPHYRUS_BLOG_MAYLIKE_TEMPLATES:
            if not ele[0] == ZEPHYRUS_BLOG_MAYLIKE_DEFAULT_TEMPLATE:
                ZEPHYRUS_BLOG_MAYLIKE_TEMPLATES.append(ele)

    if hasattr(_settings, 'ZEPHYRUS_BLOG_DATE_TEMPLATES'):
        for ele in _settings.ZEPHYRUS_BLOG_DATE_TEMPLATES:
            if not ele[0] == ZEPHYRUS_BLOG_MAYLIKE_DEFAULT_TEMPLATE:
                ZEPHYRUS_BLOG_DATE_TEMPLATES.append(ele)
                
                
    THANK_DEFAULT_TEMPLATE = 'landing/ThankYou.html'

    THANK_TEMPLATES = [
        (THANK_DEFAULT_TEMPLATE, _("Default Thank You Page")),
    ]

    if hasattr(_settings, 'THANK_TEMPLATES'):
        for ele in _settings.THANK_TEMPLATES:
            if not ele[0] == "landing/ThankYou.html":
                THANK_TEMPLATES.append(ele)

    CALL_TO_ACTION_DEFAULT_TEMPLATE = \
        "blog_extension/call_to_action/Default.html"

    CALL_TO_ACTION_TEMPLATES = [
        (CALL_TO_ACTION_DEFAULT_TEMPLATE, _("Default")),
    ]

    if hasattr(_settings, 'CALL_TO_ACTION_TEMPLATES'):
        for ele in _settings.CALL_TO_ACTION_TEMPLATES:
            if not ele[0] == "blog_extension/call_to_action/Default.html":
                CALL_TO_ACTION_TEMPLATES.append(ele)

    CALL_TO_ACTION_FORM_DEFAULT_TEMPLATE = \
        "blog_extension/call_to_action/DefaultForm.html"

    CALL_TO_ACTION_FORM_TEMPLATES = [
        (CALL_TO_ACTION_FORM_DEFAULT_TEMPLATE, _("Default")),
    ]

    if hasattr(_settings, 'CALL_TO_ACTION_FORM_TEMPLATES'):
        for ele in _settings.CALL_TO_ACTION_FORM_TEMPLATES:
            if not ele[0] == "blog_extension/call_to_action/DefaultForm.html":
                CALL_TO_ACTION_FORM_TEMPLATES.append(ele)



    formTemplates = _settings.DJANGOCMS_FORMS_TEMPLATES
    filteredTemplates = [t for t in CALL_TO_ACTION_FORM_TEMPLATES  if t not in _settings.DJANGOCMS_FORMS_TEMPLATES]
    
    _settings.DJANGOCMS_FORMS_TEMPLATES = formTemplates + filteredTemplates



