#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: arrange_template.py 11055 2018-05-14 09:46:32Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2018-05-14 17:46:32 +0800 (週一, 14 五月 2018) $
# $Revision: 11055 $

import os

from django.core.management.base import BaseCommand, CommandError

from Zephyrus.boilerplate.management.commands import createLogger

logger = createLogger(__name__, "ArrangeTemplate.log") 

class Command(BaseCommand):

    help = "Arrange template pages to fulfill requirements of further commands"
    args = '<template folder>'

    def handle(self, *args, **options):

        if len(args) < 1:
            raise CommandError(
                "You must specify a folder to arrange template."
                )

        templatePath = args[0]
        
        for f in os.listdir(templatePath):
            tempPath = os.path.join(templatePath, f)
            
            num = 0
            hasIndex = False
            for root, dirs, files in os.walk(tempPath):
                for f2 in files:
                    path = os.path.join(root, f2)
                    result = os.path.splitext(path)[-1]
                    if result == ".html":
                        num += 1
                if 'index.html' in files or 'Index.html' in files:
                    hasIndex = True
                    
            if hasIndex:
                continue
                
            if num == 1:
                for root, dirs, files in os.walk(tempPath):
                    for f2 in files:
                        path = os.path.join(root, f2)
                        newPath = os.path.join(root, 'index.html')
                        result = os.path.splitext(path)[-1]
                        if result == ".html":
                            os.rename(path, newPath)
                            logger.info('Rename %s to index.html' % f2)
                        
        logger.info('ALL OK!')
        