#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: __init__.py 12062 2020-04-09 19:13:28Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2020-04-10 04:13:28 +0900 (週五, 10 四月 2020) $
# $Revision: 12062 $

from django.conf import settings as _settings
from django.utils.translation import ugettext_lazy as _

class settings(object):
    ZEPHYRUS_BLOG_MAYLIKE_DEFAULT_TEMPLATE = \
        "blog_extension/Default.html"

    ZEPHYRUS_BLOG_DATE_DEFAULT_TEMPLATE = \
        "blog_extension/Date.html"

    ZEPHYRUS_BLOG_MAYLIKE_TEMPLATES = [
        (ZEPHYRUS_BLOG_MAYLIKE_DEFAULT_TEMPLATE, _("Default")),
    ]
    ZEPHYRUS_BLOG_DATE_TEMPLATES = [
        (ZEPHYRUS_BLOG_DATE_DEFAULT_TEMPLATE, _("Default")),
    ]

    if hasattr(_settings, 'ZEPHYRUS_BLOG_MAYLIKE_TEMPLATES'):
        for ele in _settings.ZEPHYRUS_BLOG_MAYLIKE_TEMPLATES:
            if not ele[0] == ZEPHYRUS_BLOG_MAYLIKE_DEFAULT_TEMPLATE:
                ZEPHYRUS_BLOG_MAYLIKE_TEMPLATES.append(ele)

    if hasattr(_settings, 'ZEPHYRUS_BLOG_DATE_TEMPLATES'):
        for ele in _settings.ZEPHYRUS_BLOG_DATE_TEMPLATES:
            if not ele[0] == ZEPHYRUS_BLOG_MAYLIKE_DEFAULT_TEMPLATE:
                ZEPHYRUS_BLOG_DATE_TEMPLATES.append(ele)
    
    CALL_TO_ACTION_EMAIL_SUBJECT = f'Your Special File arrived'
    
    if hasattr(_settings, 'CALL_TO_ACTION_EMAIL_SUBJECT'):
        CALL_TO_ACTION_EMAIL_SUBJECT = _settings.CALL_TO_ACTION_EMAIL_SUBJECT 
    
    CALL_TO_ACTION_PDF_DEFAULT_TEMPLATE = 'blog_extension/call_to_action/PDFBase.html'
    if hasattr(_settings, 'CALL_TO_ACTION_PDF_BASE_TEMPLATE'):
        CALL_TO_ACTION_PDF_BASE_TEMPLATE = _settings.CALL_TO_ACTION_PDF_BASE_TEMPLATE
    else:
        CALL_TO_ACTION_PDF_BASE_TEMPLATE = CALL_TO_ACTION_PDF_DEFAULT_TEMPLATE
                
                
    THANK_DEFAULT_TEMPLATE = 'landing/ThankYou.html'

    THANK_TEMPLATES = [
        (THANK_DEFAULT_TEMPLATE, _("Default Thank You Page")),
    ]

    if hasattr(_settings, 'THANK_TEMPLATES'):
        for ele in _settings.THANK_TEMPLATES:
            if not ele[0] == "landing/ThankYou.html":
                THANK_TEMPLATES.append(ele)

    CALL_TO_ACTION_DEFAULT_TEMPLATE = \
        "blog_extension/call_to_action/Default.html"

    CALL_TO_ACTION_TEMPLATES = [
        (CALL_TO_ACTION_DEFAULT_TEMPLATE, _("Default Call To Action Template")),
    ]

    if hasattr(_settings, 'CALL_TO_ACTION_TEMPLATES'):
        for ele in _settings.CALL_TO_ACTION_TEMPLATES:
            if not ele[0] == "blog_extension/call_to_action/Default.html":
                CALL_TO_ACTION_TEMPLATES.append(ele)

    CALL_TO_ACTION_FORM_DEFAULT_TEMPLATE = \
        "blog_extension/call_to_action/DefaultForm.html"

    CALL_TO_ACTION_FORM_TEMPLATES = [
        (CALL_TO_ACTION_FORM_DEFAULT_TEMPLATE, _("Default Call To Action Form Template")),
    ]

    if hasattr(_settings, 'CALL_TO_ACTION_FORM_TEMPLATES'):
        for ele in _settings.CALL_TO_ACTION_FORM_TEMPLATES:
            if not ele[0] == "blog_extension/call_to_action/DefaultForm.html":
                CALL_TO_ACTION_FORM_TEMPLATES.append(ele)



    if hasattr(_settings, 'DJANGOCMS_FORMS_TEMPLATES'):
        formTemplates = _settings.DJANGOCMS_FORMS_TEMPLATES
        filteredTemplates = [t for t in CALL_TO_ACTION_FORM_TEMPLATES  if t not in _settings.DJANGOCMS_FORMS_TEMPLATES]
        
        _settings.DJANGOCMS_FORMS_TEMPLATES = formTemplates + filteredTemplates
    else:
        _settings.DJANGOCMS_FORMS_TEMPLATES = [t for t in CALL_TO_ACTION_FORM_TEMPLATES]



