#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: cms_dumpdata.py 12436 2020-07-30 08:41:42Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2020-07-30 17:41:42 +0900 (週四, 30 七月 2020) $
# $Revision: 12436 $

import os
import sys
import json
import six

if six.PY2:
    from StringIO import StringIO
else:
    from io import StringIO

from django.core.management.base import BaseCommand
from django.core import serializers
from django.conf import settings
from django.db.models.query import QuerySet

from Iuppiter.DjangoUtil import DJANGO_VERSION

if DJANGO_VERSION >= 11100: # django >= 1.11
    from django.apps import apps
else:
    from django.db.models import get_app, get_models

class Command(BaseCommand):

    help = 'Dump all data include filer.File to initial_data.json'

    def add_arguments(self, parser):
        parser.add_argument('path', type=str, help="path")
        parser.add_argument(
            '-n', '--noAuth', 
            action='store_true',
            help="No export auth data.")
    
    def handle(self, *args, **options):
        if DJANGO_VERSION >= 11100:
            app = apps.get_app_config('filer')
            modelList = [apps.get_model('filer', m) for m in app.models]
        else:
            app = get_app('filer')        
            modelList = get_models(app)
        
        dataStream = StringIO()
        
        def getObjects():
            for model in modelList:
                model.objects.queryset_class = QuerySet
                for obj in model.objects.iterator():
                    yield obj
                    
        if DJANGO_VERSION >= 11100:
            serializers.serialize(
                'json', getObjects(), indent=2, 
                use_natural_foreign_keys=True, use_natural_primary_keys=True, 
                stream=dataStream)
        else:
            serializers.serialize(
                'json', getObjects(), indent=2, 
                    use_natural_keys=True, stream=dataStream)
                
        filerData = json.loads(dataStream.getvalue())
        
        try:
        
            os.system(
                "%s manage.py dumpdata -e auth.Permission auth > authData.json" %  
                sys.executable)

            os.system(
                "%s manage.py dumpdata cms.Treenode > treenodeData.json" %  
                sys.executable)
                
            excludeApps = [
                'auth',
                'sites',
                'filer',
                'contenttypes',
                'cms.Treenode',
            ]
            
            if "Zephyrus.statistics" in settings.INSTALLED_APPS:
                excludeApps.append("statistics")
            if "Iuno.redirect" in settings.INSTALLED_APPS:
                excludeApps.append("redirect")
                
            excludeStr = "-e %s" % " -e ".join(excludeApps)
            
            os.system("%s manage.py dumpdata %s > otherData.json" % (sys.executable, excludeStr))
            
            with open('authData.json') as f:
                content = f.read()
                authData = json.loads(content[content.index('['):])
            with open('treenodeData.json') as f:
                content = f.read()
                treenodeData = json.loads(content[content.index('['):])
            with open('otherData.json') as f:
                content = f.read()
                otherData = json.loads(content[content.index('['):])

            data = []

            if not options['noAuth']:
                for ele in authData:
                    data.append(ele)

            
            for ele in filerData:
                data.append(ele)
            for ele in treenodeData:
                data.append(ele)
            for ele in otherData:
                data.append(ele)
            

            path = os.path.join(options['path'])

            with open(path, 'w', encoding="utf-8") as f:
                try:
                    content = f.write(
                        json.dumps(data, indent=4, ensure_ascii=False, default=str))
                except Exception as e:
                    if os.path.exists(path):
                        os.remove(path)
                    raise
        
        finally:
        
            if os.path.exists('authData.json'):
                os.remove('authData.json')
                
            if os.path.exists('treenodeData.json'):
                os.remove('treenodeData.json')
                
            if os.path.exists('otherData.json'):
                os.remove('otherData.json')
                
            
        
