#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: __init__.py 12224 2020-05-15 09:54:33Z Andy $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Andy $
# $Date: 2020-05-15 18:54:33 +0900 (週五, 15 五月 2020) $
# $Revision: 12224 $

from django.conf.urls import url, include

from Iuppiter.DjangoUtil import DJANGO_VERSION

def patterns(prefix, *args): 
    if DJANGO_VERSION >= 11100: # django >= 1.11
        return list(args)
    else:
        from django.conf.urls import patterns as _patterns
        
        return _patterns(prefix, *args)

def attachURLs(settings, urlpatterns):
    """
    Attach patched (for example, debug and admin...etc.) urlpatterns.
    It must be called in urls.py by passing urlpatterns.

    @param settings Django project's settings module.
    @param urlpatterns urlpatterns in urls.py.
    """
    urlpatterns += patterns('',
        url(r'^', include('Zephyrus.landing.urls')),
    )

class ErrorCode(object):
    NORMAL = 0
    SAVE_EMAIL = 1
    SEND_EMAIL = 2
    EMAIL_FORMAT = 3