#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: IunoSettings.py 11221 2018-09-02 04:41:14Z Lavender $
#
# Copyright (c) 2015 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $ (last)
# $Date: 2018-09-02 12:41:14 +0800 (Sun, 02 Sep 2018) $
# $Revision: 11221 $
"""
Default settings for this project if it can't import settings.
"""

# Populate it to here as default settings.
#from django.conf.global_settings import *

# These settings is useless, these values only used in test environment.
# You should set these values in your projects settings.py.

import os

BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))

SECRET_KEY = 'k*ohwp_!xr!rz*+6b2fpff%&5tw!nyh__^#y0%w#53k11#nh9p'

if not os.path.isdir(os.path.join(BASE_DIR, "static")):
    os.mkdir(os.path.join(BASE_DIR, "static"))
    if not os.path.isdir(
        os.path.join(BASE_DIR, "static", "_Iuno.template_editor_backup")):
        os.mkdir(
            os.path.join(BASE_DIR, "static", "_Iuno.template_editor_backup"))

DEBUG = True
TEMPLATE_DEBUG = DEBUG

DATABASES = {
    'default': {
        'NAME': 'Iuno.db',
        'ENGINE': 'django.db.backends.sqlite3',
        'USER': '',
        'PASSWORD': '',
        'OPTIONS': {
            #'timeout': 60,
            #'isolation_level': None,
        },
    }
}

TIME_ZONE = 'Asia/Taipei' #'America/Chicago'
LANGUAGE_CODE = 'zh-TW' #'en-us'
USE_I18N = True
LANGUAGES = (
  ('zh-tw', 'Traditional Chinese'),
  ('zh-cn', 'Simplified Chinese'),
  ('en', 'English'),
)

MIDDLEWARE_CLASSES = (
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.auth.middleware.SessionAuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
    'django.middleware.security.SecurityMiddleware',
)

INSTALLED_APPS = (
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.admin',
    'Iuppiter.extension',
    'Iuppiter.test',
    'Iuno.tests',
    'Iuno.scaffold',
)
