#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: __init__.py 11257 2018-11-10 03:42:27Z Kevin $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Kevin $ (last)
# $Date: 2018-11-10 11:42:27 +0800 (Sat, 10 Nov 2018) $
# $Revision: 11257 $

from googleapiclient.errors import HttpError

from Iuno.cloud.storage.gos import path
from Iuno.cloud.storage.gos.Service import (
    service, BY_ID, BY_PATH, getFile, getFiles, handleHttpError)


def listdir(path):
    path = path.replace("\\", "/")
    return [f["name"] for f in getFiles(path, type=BY_PATH)]


def mkdir(path):
    # pre-process params
    path = path.replace("\\", "/")
    names = path.split("/")

    # split path to parent & filename
    parent = getFile("/".join(names[:-1]), type=BY_PATH).get("id")
    dirName = names[-1]

    service.files().create(body={
        "name": dirName,
        "parents": [parent],
        "mimeType": "application/vnd.google-apps.folder"
    }).execute()


from Iuno.cloud.storage.gos import path as _path

def makedirs(path):
    # pre-process params
    path = path.replace("\\", "/")
    names = path.split("/")

    # create directories iteratively
    for i, name in enumerate(names):
        dst = "/".join(names[:i + 1])
        if not _path.exists(dst):
            mkdir(dst)


def _move(fileId, folderId):
    # Retrieve the existing parents to remove
    try:
        file = service.files().get(
            fileId=fileId, fields="parents").execute()
    except HttpError as e:
        handleHttpError(e)

    previousParents = ",".join(file.get("parents"))

    # Move the file to the new folder
    service.files().update(
        fileId=fileId,
        addParents=folderId,
        removeParents=previousParents).execute()


def _rename(fileId, title):
    # Rename the file.
    service.files().update(
        fileId=fileId,
        body={"name": title},
        fields="name").execute()


def rename(src, dst):
    # pre-process params
    fileId = getFile(src, type=BY_PATH).get("id")
    src = src.replace("\\", "/")
    dst = dst.replace("\\", "/")
    srcNames = src.split("/")
    dstNames = dst.split("/")

    # check if dst and src are in the same folder
    if srcNames[:-1] != dstNames[:-1]:
        _move(fileId, getFile(
            "/".join(dstNames[:-1]), type=BY_PATH)["id"])

    if srcNames[-1] != dstNames[-1]:
        _rename(fileId, dstNames[-1])


def remove(path):
    # pre-process params
    path = path.replace("\\", "/")
    fileId = getFile(path, type=BY_PATH).get("id")

    # delete the file
    try:
        service.files().delete(fileId=fileId).execute()
    except HttpError as e:
        handleHttpError(e)
