from django.db import models
from django.utils.translation import ugettext_lazy as _

from oscar.apps.catalogue.abstract_models import AbstractCategory, AbstractOption, AbstractProductClass
from oscar.apps.partner.models import Partner

class Category(AbstractCategory):
    partner = models.ForeignKey(
        Partner,
        null=True,
        on_delete=models.CASCADE,
        related_name='categoryPartner',
        verbose_name=_("Partner"),
    )
    
class Option(AbstractOption):
    partner = models.ForeignKey(
        Partner,
        null=True,
        on_delete=models.CASCADE,
        related_name='optionOwner',
        verbose_name=_("Partner"),
    )
    
class ProductClass(AbstractProductClass):
    partner = models.ForeignKey(
        Partner,
        null=True,
        on_delete=models.CASCADE,
        related_name='productClassPartner',
        verbose_name=_("Partner"),
    )

from oscar.apps.catalogue.models import *  # noqa isort:skip

