from django.conf.urls import url
from django.utils.translation import gettext_lazy as _

import oscar.apps.dashboard.catalogue.apps as apps

from oscar.core.loading import get_class

class CatalogueDashboardConfig(apps.CatalogueDashboardConfig):
    name = 'dashboard.catalogue'
    
    permissions_map = _map = {
        'catalogue-product': (['is_staff'], ['partner.dashboard_access']),
        'catalogue-product-create': (['is_staff'],
                                     ['partner.dashboard_access']),
        'catalogue-product-list': (['is_staff'], ['partner.dashboard_access']),
        'catalogue-product-delete': (['is_staff'],
                                     ['partner.dashboard_access']),
        'catalogue-product-lookup': (['is_staff'],
                                     ['partner.dashboard_access']),
        
        'catalogue-category-list': (['is_staff'],
                                     ['partner.dashboard_access']),
        'catalogue-category-detail-list': (['is_staff'],
                                     ['partner.dashboard_access']),
        'catalogue-category-create': (['is_staff'],
                                     ['partner.dashboard_access']),
        'catalogue-category-create-child': (['is_staff'],
                                     ['partner.dashboard_access']),
        'catalogue-category-update': (['is_staff'],
                                     ['partner.dashboard_access']),
        'catalogue-category-delete': (['is_staff'],
                                     ['partner.dashboard_access']),
                                     
        'catalogue-class-create': (['is_staff'],
                                     ['partner.dashboard_access']),
        'catalogue-class-list': (['is_staff'],
                                     ['partner.dashboard_access']),
        'catalogue-class-update': (['is_staff'],
                                     ['partner.dashboard_access']),
        'catalogue-class-delete': (['is_staff'],
                                     ['partner.dashboard_access']),
                                     
        'catalogue-option-list': (['is_staff'],
                                     ['partner.dashboard_access']),
        'catalogue-option-create': (['is_staff'],
                                     ['partner.dashboard_access']),
        'catalogue-option-update': (['is_staff'],
                                     ['partner.dashboard_access']),
        'catalogue-option-delete': (['is_staff'],
                                     ['partner.dashboard_access']),
    }
  
    def ready(self):
        super().ready()
        # 在 dashboard 內 get_class 有 get 不到 override 的問題，目前初步判斷是
        # oscar.core.loading 的 _find_registered_app_name 使用
        # module_label.split('.')[0] 結果只抓到外層的 app 造成的
        from dashboard.catalogue.views import (
            CategoryListView,
            CategoryCreateView,
            CategoryUpdateView,
            ProductCreateUpdateView,
            ProductClassListView,
            ProductClassCreateView,
            ProductListView,
            OptionListView,
            OptionCreateView,
            ProductClassUpdateView,
            # OptionCreateUpdateView,
        )
        self.product_list_view = ProductListView
        # self.product_lookup_view = get_class('dashboard.catalogue.views',
                                             # 'ProductLookupView')
        # self.product_create_redirect_view = get_class('dashboard.catalogue.views',
                                                      # 'ProductCreateRedirectView')
        self.product_createupdate_view = ProductCreateUpdateView
        # self.product_delete_view = get_class('dashboard.catalogue.views',
                                             # 'ProductDeleteView')

        self.product_class_create_view = ProductClassCreateView
        self.product_class_update_view = ProductClassUpdateView
        self.product_class_list_view = ProductClassListView
        # self.product_class_delete_view = get_class('dashboard.catalogue.views',
                                                   # 'ProductClassDeleteView')

        self.category_list_view = CategoryListView
        # self.category_detail_list_view = get_class('dashboard.catalogue.views',
                                                   # 'CategoryDetailListView')
        self.category_create_view = CategoryCreateView
        self.category_update_view = CategoryUpdateView
        # self.category_delete_view = get_class('dashboard.catalogue.views',
                                              # 'CategoryDeleteView')

        # self.stock_alert_view = get_class('dashboard.catalogue.views',
                                          # 'StockAlertListView')

        # self.attribute_option_group_create_view = get_class('dashboard.catalogue.views',
                                                            # 'AttributeOptionGroupCreateView')
        # self.attribute_option_group_list_view = get_class('dashboard.catalogue.views',
                                                          # 'AttributeOptionGroupListView')
        # self.attribute_option_group_update_view = get_class('dashboard.catalogue.views',
                                                            # 'AttributeOptionGroupUpdateView')
        # self.attribute_option_group_delete_view = get_class('dashboard.catalogue.views',
                                                            # 'AttributeOptionGroupDeleteView')

        self.option_list_view = OptionListView
        self.option_create_view = OptionCreateView
        # self.option_create_update_view = OptionCreateUpdateView
        # self.option_update_view = get_class('dashboard.catalogue.views', 'OptionUpdateView')
        # self.option_delete_view = get_class('dashboard.catalogue.views', 'OptionDeleteView')
        
        

