from oscar.core.loading import get_classes, get_model
# from django import forms
from treebeard.forms import movenodeform_factory

(_ProductClassSelectForm,
 _ProductClassForm,
 _CategoryForm,
 _OptionForm,
) = get_classes('dashboard.catalogue.forms',(
        'ProductClassSelectForm',
        'ProductClassForm',
        'CategoryForm',
        'OptionForm',
    )
)

Category = get_model('catalogue', 'Category')
ProductClass = get_model('catalogue', 'ProductClass')
Option = get_model('catalogue', 'Option')

class ProductClassSelectForm(_ProductClassSelectForm):
    
    
    def __init__(self, user, *args, **kwargs):
        super().__init__(*args, **kwargs)
        qs = self.fields['product_class'].queryset
        
        if not user.is_staff:
            self.fields['product_class'].queryset = qs.filter(
                partner__in=user.partners.all())
                
class ProductClassForm(_ProductClassForm):

    class Meta:
        model = ProductClass
        fields=['name', 'partner', 'requires_shipping', 'track_stock', 
            'options']

    def __init__(self, user, *args, **kwargs):
        super().__init__(*args, **kwargs)
        qs = self.fields["options"].queryset
        if not user.is_staff:
            self.fields["options"].queryset = qs.filter(
                partner__in=user.partners.all())
        qs = self.fields["partner"].queryset
        self.fields["partner"].queryset = user.partners.all()



class CategoryForm(_CategoryForm):

    class Meta:
        model = Category
        fields=['name', 'partner', 'description', 'image', '_position', \
            '_ref_node_id']


    def __init__(self, user, *args, **kwargs):
        super().__init__(*args, **kwargs)
        choices = self.fields["_ref_node_id"].choices
        if not user.is_staff:
            categories = Category.objects.filter(
                partner__in=user.partners.all()).values_list('id')
            categories = [c[0] for c in list(categories)]
            newChoices = []
            for c in choices:
                if c[0] == 0 or c[0] in categories:
                    # 0: ---root---
                    newChoices.append(c)
            self.fields["_ref_node_id"].choices = newChoices
        self.fields['partner'].queryset = user.partners.all()


class OptionForm(_OptionForm):

    class Meta:
        model = Option
        fields = ['name', 'type', 'partner', ]

    def __init__(self, user, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self.fields['partner'].queryset = user.partners.all()
        
            
                
        