from oscar.core.loading import get_classes, get_model
from django.utils.translation import gettext_lazy as _
from django_tables2 import A, Column, LinkColumn, TemplateColumn

_CategoryTable, _OptionTable \
    = get_classes('dashboard.catalogue.tables',
                  ('CategoryTable', 'OptionTable'))
                  
Category = get_model('catalogue', 'Category')
ProductClass = get_model('catalogue', 'ProductClass')
Option = get_model('catalogue', 'Option')
                  
class CategoryTable(_CategoryTable):
    
    class Meta(_CategoryTable.Meta):
        fields = ('name', 'description', 'partner')
        
class OptionTable(_OptionTable):
    
    class Meta(_OptionTable.Meta):
        fields = ('name', 'type', 'partner')
        sequence = ('name', 'type', 'partner', 'actions')
