from django.core.urlresolvers import reverse
from django.shortcuts import redirect
from django.contrib import messages
from django.utils.translation import ugettext_lazy as _
from oscar.core.loading import get_classes, get_model

from dashboard.catalogue.formsets import ProductCategoryFormSet
from dashboard.catalogue.forms import (
    ProductClassSelectForm, ProductClassForm, CategoryForm, OptionForm)
from dashboard.catalogue.tables import CategoryTable, OptionTable

(_CategoryListView,
 _CategoryCreateView,
 _CategoryUpdateView,
 _ProductCreateUpdateView,
 _ProductClassListView,
 _ProductClassCreateView,
 _ProductListView,
 _OptionListView,
 _OptionCreateView,
 _ProductClassCreateView,
 _ProductClassUpdateView,
 _OptionCreateUpdateView,
) = get_classes('dashboard.catalogue.views',(
        'CategoryListView',
        'CategoryCreateView',
        'CategoryUpdateView',
        'ProductCreateUpdateView',
        'ProductClassListView',
        'ProductClassCreateView',
        'ProductListView',
        'OptionListView',
        'OptionCreateView',
        'ProductClassCreateView',
        'ProductClassUpdateView',
        'OptionCreateUpdateView',
    )
)

Category = get_model('catalogue', 'Category')
ProductClass = get_model('catalogue', 'ProductClass')
Option = get_model('catalogue', 'Option')

class CategoryListView(_CategoryListView):

    def get(self, request, *args, **kwargs):
        if request.user.is_staff:
            self.table_class = CategoryTable
        return super().get(request, *args, **kwargs)

    def get_queryset(self):
        if self.request.user.is_staff:
            return Category.get_root_nodes()
        else:
            return Category.get_root_nodes().filter(
                partner__in=self.request.user.partners.all())

    def get_context_data(self, *args, **kwargs):
        ctx = super().get_context_data(*args, **kwargs)
        if self.request.user.is_staff:
            ctx['child_categories'] = Category.get_root_nodes()
        else:
            ctx['child_categories'] = Category.get_root_nodes().filter(
                partner__in=self.request.user.partners.all())
        return ctx
        
class CategoryCreateView(_CategoryCreateView):

    form_class = CategoryForm
    
    def get_form_kwargs(self):
        rt = super().get_form_kwargs()
        rt["user"] = self.request.user
        return rt

    def form_valid(self, form):
        obj = form.save()
        # obj.partner = self.request.user.partners.first()
        # obj.save()
        messages.info(self.request, _("Category created successfully"))
        return redirect('dashboard:catalogue-category-list') 
        
class CategoryUpdateView(_CategoryUpdateView):

    form_class = CategoryForm
    
    def get_form_kwargs(self):
        rt = super().get_form_kwargs()
        rt["user"] = self.request.user
        return rt
  
class ProductCreateUpdateView(_ProductCreateUpdateView):
    category_formset = ProductCategoryFormSet
    
class ProductClassCreateView(_ProductClassCreateView):

    form_class = ProductClassForm

    def form_valid(self, form):
        obj = form.save()
        # obj.partner = self.request.user.partners.first()
        # obj.save()
        return super().form_valid(form)
        
    def get_form_kwargs(self):
        rt = super().get_form_kwargs()
        rt["user"] = self.request.user
        return rt
        
        
class ProductClassUpdateView(_ProductClassUpdateView):

    form_class = ProductClassForm
    
    def get_form_kwargs(self):
        rt = super().get_form_kwargs()
        rt["user"] = self.request.user
        return rt
    
    
class ProductClassListView(_ProductClassListView):

    def get_queryset(self):
        if self.request.user.is_staff:
            return ProductClass.objects.all()
        else:
            return ProductClass.objects.filter(
                partner__in=self.request.user.partners.all())
                
class ProductListView(_ProductListView):
    productclass_form_class = ProductClassSelectForm
    
    def get_context_data(self, **kwargs):
        ctx = super(_ProductListView, self).get_context_data(**kwargs)
        ctx['form'] = self.form
        ctx['productclass_form'] = self.productclass_form_class(
            self.request.user)
        return ctx
        
class OptionListView(_OptionListView):

    def get(self, request, *args, **kwargs):
        if request.user.is_staff:
            self.table_class = OptionTable
        return super().get(request, *args, **kwargs)
        
    def get_queryset(self):
        if self.request.user.is_staff:
            return Option.objects.all()
        else:
            return Option.objects.filter(
                partner__in=self.request.user.partners.all())


class OptionCreateUpdateView(_OptionCreateUpdateView):

    form_class = OptionForm

    def get_context_data(self, **kwargs):
        ctx = super().get_context_data(**kwargs)
        ctx['title'] = self.get_title()
        ctx['user'] = self.request.user
        return ctx

    def get_form_kwargs(self):
        rt = super().get_form_kwargs()
        rt["user"] = self.request.user
        return rt
        
class OptionCreateView(OptionCreateUpdateView, _OptionCreateView):
    
    # form_class = OptionForm

    def form_valid(self, form):
        obj = form.save()
        # obj.partner = self.request.user.partners.first()
        # obj.save()
        return super().form_valid(form)
    
    
    