#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: AttachSettings.py 10407 2017-10-24 10:14:28Z David $
#
# Copyright (c) 2013 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: David $
# $Date: 2017-10-24 18:14:28 +0800 (Tue, 24 Oct 2017) $
# $Revision: 10407 $

import os

def attachSettings(settingsDict):

    installed = settingsDict['INSTALLED_APPS']

    if 'Theophrastus' in installed:

        def attachAttrs(attrs):
            for attr in attrs:
                name, _v = attrs[attr]
                _attr = settingsDict.get(attr, _v)
                settingsDict[name] = _attr

        CURRENT_PATH = os.path.dirname(__file__)

        #=======================================================================
        # Attach TEMPLATE_DIRS.
        #=======================================================================

        THEOPHRASTUS_TEMPLATE_DIRS = settingsDict.get(
            'THEOPHRASTUS_TEMPLATE_DIRS',
            os.path.join(CURRENT_PATH, 'templates')
        )

        templateDirs = list(settingsDict['TEMPLATES'][0]['DIRS'])
        templateDirs.extend([THEOPHRASTUS_TEMPLATE_DIRS])
        settingsDict['TEMPLATES'][0]['DIRS'] = tuple(templateDirs)

        #=======================================================================
        # Attach INSTALLED_APPS.
        #=======================================================================

        installedApps = settingsDict.get('THEOPHRASTUS_INSTALLED_APPS', [
            # for modification of newsletter_historic.html in 
            # newsletter_extension, we change order of installed_apps between
            # newsletter_extension and emencia.django.newsletter.
            
            'Theophrastus.newsletter_extension',
            'emencia.django.newsletter',
            'Theophrastus',
            'Theophrastus.cloud',
            'Theophrastus.editor',
            'Theophrastus.statistics',
            'Theophrastus.document',
            # django-selectable
            'selectable',         
        ])

        if settingsDict.get('THEOPHRASTUS_ENABLE_INTEGRATION', False):
            installedApps.append('Theophrastus.integration')
            installedApps.append('Theophrastus.api')

        index = installed.index('Theophrastus')
        startApps = list(installed[:index])
        endApps = list(installed[index + 1:])

        startApps.extend(installedApps)
        startApps.extend(endApps)
        settingsDict['INSTALLED_APPS'] = tuple(startApps)

        attachAttrs(attrs={
            'THEOPHRASTUS_ENABLE_INTEGRATION': ('ENABLE_INTEGRATION', False),
        })

        #=======================================================================
        # Attach editor template settings.
        #=======================================================================

        attachAttrs(attrs={
            # Set upload path.
            'THEOPHRASTUS_TEMPLATE_DIR_PATH': (
                'TEMPLATE_DIR_PATH',
                'editor/tinymceTemplate/'
            ),
        })

        #=======================================================================
        # Attach upload settings.
        #=======================================================================

        attachAttrs(attrs={
            # Set upload path.
            'THEOPHRASTUS_UPLOAD_PATH': (
                'UPLOAD_PATH',
                os.path.join(settingsDict['MEDIA_ROOT'], 'uploads')
            ),
            # Set upload extra number.
            'THEOPHRASTUS_UPLOAD_EXTRA': ('UPLOAD_EXTRA', 3),
        })

        #=======================================================================
        # Mailer.
        #=======================================================================
        import logging

        attachAttrs(attrs={
            'THEOPHRASTUS_LOG_LEVEL': (
                'LOG_LEVEL', logging.INFO
            ),
            # Enable fake send mode.
            'THEOPHRASTUS_ENABLE_FAKE_MAIL': (
                'ENABLE_FAKE_MAIL', False
            ),
            # Enable fake SMTP connection.
            'THEOPHRASTUS_ENABLE_FAKE_SMTP': (
                'ENABLE_FAKE_SMTP', False
            ),
            # Set log file for mail server.
            'THEOPHRASTUS_MAIL_SERVER_LOGFILE': (
                'MAIL_SERVER_LOGFILE',
                os.path.join(CURRENT_PATH, 'mailServer.log')
            ),
            # Set log file for apscheduler.
            'THEOPHRASTUS_APSCHEDULER_LOGFILE': (
                'APSCHEDULER_LOGFILE',
                os.path.join(CURRENT_PATH, 'apscheduler.log')
            ),
            # Set log file for apscheduler.
            'THEOPHRASTUS_ENABLE_APSCHEDULER_LOGFILE': (
                'ENABLE_APSCHEDULER_LOGFILE', False
            ),
            # Set log file for mailer.
            'THEOPHRASTUS_MAILER_LOGFILE': (
                'MAILER_LOGFILE',
                os.path.join(CURRENT_PATH, 'mailer.log')
            ),
            # Set mailer thread pool counts.
            'THEOPHRASTUS_MAILER_THREAD_POOL_COUNT': (
                'MAILER_THREAD_POOL_COUNT', 10
            ),
            # Set sendbox thread pool counts.
            'THEOPHRASTUS_SENDBOX_THREAD_POOL_COUNT': (
                'SENDBOX_THREAD_POOL_COUNT', 25
            ),
            'THEOPHRASTUS_SEND_FAILED_COUNT': (
                'SEND_FAILED_COUNT', 3
            ),
            'THEOPHRASTUS_WAITTING_TIMEOUT': (
                'WAITTING_TIMEOUT', 6
            ),
        })

        #=======================================================================
        # API.
        #=======================================================================

        attachAttrs(attrs={
            # Set log file for api.
            'THEOPHRASTUS_API_LOG': (
                'API_LOG',
                os.path.join(CURRENT_PATH, 'api.log')
            ),
        })

        #=======================================================================
        # Amazon web service.
        #=======================================================================

        AWS_ACCESS_KEY_ID = 'AKIAIS2EYEZOZEPAZE7Q'
        AWS_SECRET_ACCESS_KEY = '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'

        attachAttrs(attrs={
            # Set access key id.
            'AWS_ACCESS_KEY_ID': (
                'AWS_ACCESS_KEY_ID', AWS_ACCESS_KEY_ID
            ),
            # Set secret key id.
            'AWS_SECRET_ACCESS_KEY': (
                'AWS_SECRET_ACCESS_KEY', AWS_SECRET_ACCESS_KEY
            ),
            # Set log.
            'THEOPHRASTUS_AMAZON_LOGFILE': (
                'AMAZON_LOGFILE', os.path.join(CURRENT_PATH, 'amazon.log')
            ),
        })

        #=======================================================================
        # Facebook.
        #=======================================================================

        attachAttrs(attrs={
            # Set access key id.
            'THEOPHRASTUS_FACEBOOK_FEED_APP_ID': (
                'FACEBOOK_FEED_APP_ID', '171864859549153'
            ),
        })

        #=======================================================================


        from Iuno import Patch
        Patch.extendAll(settingsDict)
