#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: Amazon.py 10285 2017-09-11 01:55:49Z David $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: David $
# $Date: 2017-09-11 09:55:49 +0800 (Mon, 11 Sep 2017) $
# $Revision: 10285 $

import boto

from django.conf import settings

class SES(object):
    def __init__(self, AWS_ACCESS_KEY_ID, AWS_SECRET_ACCESS_KEY):

        self.connection = boto.connect_ses(
            AWS_ACCESS_KEY_ID, AWS_SECRET_ACCESS_KEY)

    def getIdentityNotificationAttributes(self, email):

        values = self.connection._make_request(
            "GetIdentityNotificationAttributes", {"Identities.member.1": email})
        values = values['GetIdentityNotificationAttributesResponse']
        values = values['GetIdentityNotificationAttributesResult']
        values = values['NotificationAttributes']['entry']['value']
        return values

    def setIdentityNotificationTopic(self, notificationType, identity, topic):

        self.connection._make_request(
            "SetIdentityNotificationTopic", {
                'NotificationType': notificationType,
                'Identity': identity,
                'SnsTopic': topic
            }
        )

    def getAllVerifiedSenders(self):

        response = self.connection.list_verified_email_addresses()
        response = response.get('ListVerifiedEmailAddressesResponse', {})
        result = response.get('ListVerifiedEmailAddressesResult', {})
        verifiedList = result.get('VerifiedEmailAddresses', [])
        return verifiedList

    def verifyEmailAddress(self, email):

        self.connection.verify_email_address(email)

    def deleteVerifiedEmailAddress(self, email):

        response = self.connection.delete_verified_email_address(email)
        response = response.get('DeleteVerifiedEmailAddressResponse', {})
        return response

class SNS(object):
    def __init__(self, AWS_ACCESS_KEY_ID, AWS_SECRET_ACCESS_KEY):

        self.connection = boto.connect_sns(
            AWS_ACCESS_KEY_ID, AWS_SECRET_ACCESS_KEY)

    def getAllTopicArns(self):
        allTopics = self.connection.get_all_topics()
        allTopics = allTopics['ListTopicsResponse']['ListTopicsResult']
        allTopics = allTopics['Topics']
        allTopics = [d['TopicArn'] for d in allTopics]
        return allTopics

    def createTopic(self, name):
        topic = self.connection.create_topic(name)
        topic = topic['CreateTopicResponse']['CreateTopicResult']
        arn = topic['TopicArn']
        return arn

    def getAllSubscriptionsByTopic(self, topic):
        response = self.connection.get_all_subscriptions_by_topic(topic)
        response = response['ListSubscriptionsByTopicResponse']
        response = response['ListSubscriptionsByTopicResult']
        response = response['Subscriptions']
        return response

    def checkSubscriptionExist(self, topic, arnName):
        def getNameFromArn(arn):
            s = arn.split(':')
            return s[-1]

        for r in self.getAllSubscriptionsByTopic(topic):
            protocol = ['http', 'https']
            if r['Protocol'] in protocol:
                arn = getNameFromArn(r['TopicArn'])
                if arn == arnName:
                    return True
        return False

    def subscribe(self, topic, subscriptionType, link):
        if settings.SECURE_PROXY_SSL_HEADER:
            protocol = settings.SECURE_PROXY_SSL_HEADER[1]
        else:
            protocol = 'http'

        self.connection.subscribe(topic, protocol, link)