#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: IuppiterSettings.py 12363 2020-06-18 13:45:33Z Lavender $
#
# Copyright (c) 2020 Nuwa Information Co., Ltd, and individual contributors.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
#   1. Redistributions of source code must retain the above copyright notice,
#      this list of conditions and the following disclaimer.
#
#   2. Redistributions in binary form must reproduce the above copyright
#      notice, this list of conditions and the following disclaimer in the
#      documentation and/or other materials provided with the distribution.
#
#   3. Neither the name of Nuwa Information nor the names of its contributors
#      may be used to endorse or promote products derived from this software
#      without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# $Author: Lavender $ (last)
# $Date: 2020-06-18 21:45:33 +0800 (四, 18  6 2020) $
# $Revision: 12363 $

"""
Default settings for this project if it can't import settings.
"""

# Populate it to here as default settings.
#from django.conf.global_settings import *

# These settings is useless, these values only used in test environment.
# You should set these values in your projects settings.py.

import django

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = 'kfb4dwi_$4p785gmvyem=0-1k98&2dq1cpgqacq+b_$r=oy3v^'

DEBUG = True
TEMPLATE_DEBUG = DEBUG

DATABASES = {
    'default': {
        'NAME': 'Iuppiter.db',
        'ENGINE': 'django.db.backends.sqlite3',
        'USER': '',
        'PASSWORD': '',
        'OPTIONS': {
            #'timeout': 60,
            #'isolation_level': None,
        },
    }
}


TIME_ZONE = 'Asia/Taipei' #'America/Chicago'
LANGUAGE_CODE = 'zh-TW' #'en-us'
USE_I18N = True
LANGUAGES = (
  ('zh-tw', 'Traditional Chinese'),
  ('zh-cn', 'Simplified Chinese'),
  ('en', 'English'),
)

MIDDLEWARE = (
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
    'django.middleware.security.SecurityMiddleware',
)

INSTALLED_APPS = (
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
    'Iuppiter.i18n',
    'Iuppiter.test',
    'Iuppiter.tests',
    'Iuppiter.debug',
    'Iuppiter.dispatch',
    'Iuppiter.extension',
    'Iuppiter.schedule',
)

ROOT_URLCONF = 'Iuppiter.tests'

TEST_RUNNER = 'xmlrunner.extra.djangotestrunner.XMLTestRunner'

import os
packagetDir = os.path.abspath('.')
i18nTestDir = os.path.join(packagetDir, 'tests', 'i18n', 'templates')
extensionTestDir = os.path.join(packagetDir, 'tests', 'extension', 'templates')
TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [
            i18nTestDir, 
            extensionTestDir
        ],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.contrib.auth.context_processors.auth',
                'django.template.context_processors.debug',
                'django.template.context_processors.i18n',
                'django.template.context_processors.request',
                'django.template.context_processors.media',
                'django.template.context_processors.static',
                'django.template.context_processors.tz',
                'django.contrib.messages.context_processors.messages',                
            ],
        },
    },
]

# For template tag 'settings' testing.
# See more on ticket #2727
TEST_ARG = 'test'
