#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: PyCrust.py 9427 2015-09-15 08:01:29Z Judy $
#
# Copyright (c) 2015 Nuwa Information Co., Ltd, and individual contributors.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
#   1. Redistributions of source code must retain the above copyright notice,
#      this list of conditions and the following disclaimer.
#
#   2. Redistributions in binary form must reproduce the above copyright
#      notice, this list of conditions and the following disclaimer in the
#      documentation and/or other materials provided with the distribution.
#
#   3. Neither the name of Nuwa Information nor the names of its contributors
#      may be used to endorse or promote products derived from this software
#      without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# $Author: Judy $
# $Date: 2015-09-15 16:01:29 +0800 (二, 15  9 2015) $
# $Revision: 9427 $

import wx
from wx import py

# Append key binding Alt+/ to show auto completion.
class MyShell(py.shell.Shell):
    def OnKeyDown(self, event):
        key = event.GetKeyCode()
        # If the auto-complete window is up let it do its thing.
        if self.AutoCompActive():
            event.Skip()
            return

        if event.AltDown() and key == ord('/'):
            self.OnCallTipAutoCompleteManually(False)
            if not self.AutoCompActive():
                self.OnCallTipAutoCompleteManually(True)

        return py.shell.Shell.OnKeyDown(self, event)

py.crust.Shell = MyShell

# The most important thing is to override the sys.displayhook.
# This is because the interactive interpreter will put its result in
# __builtins__._, the i18n or something else will be broken with this
# behavior.
#try:
if True:
    import sys
    displayhook = sys.displayhook

    def myDisplayhook(obj):
        try:
            _ = __builtins__['_']
            result = displayhook(obj)
            __builtins__['_'] = _
            return result
        except:
            return displayhook(obj)

    sys.displayhook = myDisplayhook

class PyCrustFrame(py.crust.CrustFrame):
    def OnClose(self, event):
        super(PyCrustFrame, self).OnClose(event)
        #wx.GetApp().Exit()

class PyCrustApp(wx.App):
    """
    PyCrust standalone application.
    """

    def __init__(self, curframe, *args, **kws):
        self.curframe = curframe
        wx.App.__init__(self, *args, **kws)

    def OnInit(self):
        l = self.curframe.f_globals
        l.update(self.curframe.f_locals)
        self.frame = PyCrustFrame(locals=l)
        self.frame.Show(True)
        self.frame.Maximize()

        self.SetTopWindow(self.frame)
        return True

