#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: views.py 11265 2018-11-23 05:42:44Z Kevin $
#
# Copyright (c) 2015 Nuwa Information Co., Ltd, and individual contributors.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
#   1. Redistributions of source code must retain the above copyright notice,
#      this list of conditions and the following disclaimer.
#
#   2. Redistributions in binary form must reproduce the above copyright
#      notice, this list of conditions and the following disclaimer in the
#      documentation and/or other materials provided with the distribution.
#
#   3. Neither the name of Nuwa Information nor the names of its contributors
#      may be used to endorse or promote products derived from this software
#      without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# $Author: Kevin $ (last)
# $Date: 2018-11-23 13:42:44 +0800 (五, 23 11 2018) $
# $Revision: 11265 $

import threading
import traceback
import sys
import io as StringIO

from django.shortcuts import render
from django.template import RequestContext
from django.views.decorators.csrf import csrf_protect

@csrf_protect
def callExec(request):
    """
    Remotely invoke exec.

    @return Context dictionary.
    """
    if 'code' in request.POST:
        bakLocals = locals().copy()
        try:
            exec(request.POST['code'].replace('\r\n', '\n'))
            newVars = dict([(k, v) for k, v in list(locals().items())
                            if k not in bakLocals])
            newVars.pop('bakLocals', None)
            newVars.pop('_[1]', None) # list comprehension in dict().
        except:
            info = sys.exc_info()
            tb = StringIO.StringIO()
            traceback.print_tb(info[-1], file=tb)

            newVars = {
                'excType': info[0],
                'exception': info[1],
                'traceback': tb.getvalue(),
            }

            tb.close()

        return render(request, 'Exec.html', {
            'code': request.POST['code'],
            'vars': newVars,
        })

    return render(request, 'Exec.html', {})

def inspectThreads(request):
    """
    Inspect running threads.

    @return Context dictionary.
    """
    v = threading.enumerate()
    lv = len(v)
    txt = []
    for p in v:
        if not p.ident: # None?
            continue
            
        f = sys._current_frames()[p.ident]
        s = traceback.extract_stack(f)
        txt.append('\n'.join([str(l) for l in s]))

    return render(request, 'Threads.html', {
        'threadInfos': list(zip(v, txt)),
        'threads': v,
        'numOfThreads': lv,
        'stacks': txt,
    })
