#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: Url.py 10941 2018-03-27 08:20:06Z Kevin $
#
# Copyright (c) 2009 Nuwa Information Co., Ltd, and individual contributors.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
#   1. Redistributions of source code must retain the above copyright notice,
#      this list of conditions and the following disclaimer.
#
#   2. Redistributions in binary form must reproduce the above copyright
#      notice, this list of conditions and the following disclaimer in the
#      documentation and/or other materials provided with the distribution.
#
#   3. Neither the name of Nuwa Information nor the names of its contributors
#      may be used to endorse or promote products derived from this software
#      without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# $Author: Kevin $
# $Date: 2018-03-27 16:20:06 +0800 (二, 27  3 2018) $
# $Revision: 10941 $
#
# Contributors:
#  Jumann (original author)
#  Bear

import six

if six.PY2:
    from django.utils.encoding import smart_unicode as smart_text
else:
    from django.utils.encoding import smart_text

from django.template import Library

register = Library()

from Iuppiter.extension import flatParamsToQueryString

@register.filter
def flatHttpQueryString(url, parserValue):
    """
    Filter to make a dictionary (request.GET) be HTTP query string.

    @param url URL.
    @param parserValue Source dictionary.
    @return HTTP query string.
    """
    value = {}
    for k, v in list(parserValue.items()):
        if k == smart_text(url):
            continue
        value[k] = v

    flatQueryString = flatParamsToQueryString(value)
    result = url + flatQueryString

    # We can't assign a only character to replace it,
    # because 'unicode' object does not support item assignment.
    amp = result.find('&')
    if result.find('?') < 0 and amp > 0:
        result = result[:amp] + u'?' + result[amp + 1:]

    return result
