#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: EncryptionTest.py 1988 2009-10-23 11:15:21Z Bear $
#
# Copyright (c) 2009 Nuwa Information Co., Ltd, and individual contributors.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
#   1. Redistributions of source code must retain the above copyright notice,
#      this list of conditions and the following disclaimer.
#
#   2. Redistributions in binary form must reproduce the above copyright
#      notice, this list of conditions and the following disclaimer in the
#      documentation and/or other materials provided with the distribution.
#
#   3. Neither the name of Nuwa Information nor the names of its contributors
#      may be used to endorse or promote products derived from this software
#      without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# $Author: Bear $
# $Date: 2009-10-23 19:15:21 +0800 (週五, 23 十月 2009) $
# $Revision: 1988 $
"""
Test all encryption utilities.
"""

import unittest
import random

import six

from Iuppiter import Encryption

class EncryptionTest(unittest.TestCase):
    """
    Test case for Encryption.
    """

    def testEncryptor(self):
        """
        Test for Encryptor.
        """
        key = b'1234567890'
        e = Encryption.Encryptor(key)

        def generate():
            seed = []
            for i in range(random.randint(0, 999)):
                seed += random.sample([chr(x) for x in range(256)],
                                      random.randint(0, 256))

            return six.b(''.join(seed))

        data = generate()
        s = e.encrypt(data)
        self.assertNotEqual(s, data)

        s = e.decrypt(s)
        self.assertEqual(s, data)

        # Another key.
        key = s
        e = Encryption.Encryptor(key)

        data = generate()
        s = e.encrypt(data)
        self.assertNotEqual(s, data)

        s = e.decrypt(s)
        self.assertEqual(s, data)

if __name__ == '__main__':
    unittest.main()
