#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: ViewsTest.py 11265 2018-11-23 05:42:44Z Kevin $
#
# Copyright (c) 2015 Nuwa Information Co., Ltd, and individual contributors.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
#   1. Redistributions of source code must retain the above copyright notice,
#      this list of conditions and the following disclaimer.
#
#   2. Redistributions in binary form must reproduce the above copyright
#      notice, this list of conditions and the following disclaimer in the
#      documentation and/or other materials provided with the distribution.
#
#   3. Neither the name of Nuwa Information nor the names of its contributors
#      may be used to endorse or promote products derived from this software
#      without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# $Author: Kevin $ (last)
# $Date: 2018-11-23 13:42:44 +0800 (五, 23 11 2018) $
# $Revision: 11265 $

import unittest
import json
import django

import Iuppiter.tests

from django.http import HttpResponse
from django.test.client import Client
from django.conf.urls import url

from Iuppiter.extension.views import view, getDoc, jsonpCallback
from bs4 import BeautifulSoup

class ViewsTest(unittest.TestCase):
    """
    Test case for Views.
    """

    def setUp(self):
        self.client = Client() 

    def testViewDecorate(self):
        urlpatterns = Iuppiter.tests.urlpatterns

        @view('Test.html')
        def testView(request):
            return {'testData': 'testData'}

        testUrl = '/testDecorate/'

        if django.__version__ == '1.8':
            from django.conf.urls import patterns

            urlpatterns += patterns('',
                (r'^%s$' % testUrl[1:], testView), )
        else:
            urlpatterns += (
                url(r'^%s$' % testUrl[1:], testView),)

        response = self.client.post(testUrl)
        self.assertTrue(response.content.find(b'testData') != -1)
        self.assertTrue(isinstance(response, HttpResponse))

    def testJsonpCallback(self):
        urlpatterns = Iuppiter.tests.urlpatterns

        @jsonpCallback()
        def jsonpView(request):
            return {'testData': 'testData'}

        testUrl = '/testJsonp/'

        if django.__version__ == '1.8':
            from django.conf.urls import patterns

            urlpatterns += patterns('',
                (r'^%s$' % testUrl[1:], jsonpView), )
        else:
            urlpatterns += (
                url(r'^%s$' % testUrl[1:], jsonpView),)


        response = self.client.get(testUrl + '?jsonpcallback=abc')
        self.assertTrue(response.content == b'abc({"testData": "testData"});')

    def testGetDoc(self):
        urlpatterns = Iuppiter.tests.urlpatterns

        testUrl = '/docs/TestDocs'
        urlpatterns.append(
            url('^docs/(\w+)?$', getDoc, {
                'dir': 'docs',
                'ext': '.html',
            }))

        response = self.client.get(testUrl)
        soup = BeautifulSoup(response.content, 'html.parser')

        self.assertTrue(
            soup.find('body').text.replace('\n', '') == 'Here is the doc.')


if __name__ == '__main__':
    unittest.main()
