#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: __init__.py 11461 2019-04-16 18:26:42Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2019-04-17 02:26:42 +0800 (Wed, 17 Apr 2019) $
# $Revision: 11461 $

import os
import logging
import platform
import six

import django

from django.conf import settings

ROOT_DIR_PATH = os.path.abspath(
    os.path.join('.'))

if hasattr(settings, 'TEMPLATES'):
    TEMPLATES_DIR_PATH = settings.TEMPLATES[0]['DIRS'][0]
else:
    TEMPLATES_DIR_PATH = os.path.abspath(
        os.path.join('.', 'templates'))
    
if settings.DEBUG:
    if hasattr(settings, 'STATICFILES_DIRS'):
        STATIC_DIR_PATH = settings.STATICFILES_DIRS[0]
    else:
        STATIC_DIR_PATH = os.path.abspath(
            os.path.join('.', 'static'))
else:
    if hasattr(settings, 'STATIC_ROOT'):
        STATIC_DIR_PATH = settings.STATIC_ROOT
    else:
        STATIC_DIR_PATH = os.path.abspath(
            os.path.join('.', 'static'))
            
FIXTURES_DIR_PATH = os.path.abspath(
    os.path.join('.', 'fixtures'))
    
IMAGES_DIR_PATH = os.path.abspath(
    os.path.join('.', 'images')) 

PROJECT_MASHINES_DIR = os.path.join(
    ROOT_DIR_PATH, "BoilerplateProjects")

PROJECT_VIRTUALENV_DIR = os.path.join(
    ROOT_DIR_PATH, "ZephyrusEnv")

PROJECT_MASHINES_ZIP = os.path.join(
    os.path.dirname(os.path.abspath(__file__)), "ProjectMachine_[VERSION].zip")

PROJECT_ENV_REQUIREMENTS = os.path.join(
    os.path.dirname(os.path.abspath(__file__)), "REQUIREMENTS_[VERSION].txt")

if 'Windows' in platform.system(): 
    PROJECT_ENV_SCRIPT = os.path.join(
        os.path.dirname(os.path.abspath(__file__)), "CreateEnv.bat")
else:
    PROJECT_ENV_SCRIPT = os.path.join(
        os.path.dirname(os.path.abspath(__file__)), "CreateEnv.sh")

def createLogger(name, fileHandlerName):
    logger = logging.getLogger(name)
    logger.setLevel(logging.DEBUG)
    handler = logging.StreamHandler()
    handler.setFormatter(
        logging.Formatter("%(asctime)s - %(levelname)s - %(message)s"))
    logger.addHandler(handler)
    fileHandler = logging.FileHandler(fileHandlerName)
    fileHandler.setLevel(logging.WARNING)
    logger.addHandler(fileHandler)
    return logger
    
def toBytes(s):
    return s if six.PY2 else s.encode()
    
def open3(name, mode='r'):
    if six.PY2:
        return open(name, mode)
    else:
        if "b" in mode:
            return open(name, mode)
        else:
            return open(name, mode, encoding='utf8')

CSS_PROPERTIES = [
    #CSS3: https://www.w3schools.com/cssref/default.asp
    'align-content',
    'align-items',
    'align-self',
    'all',
    'animation',
    'animation-delay',
    'animation-direction',
    'animation-duration',
    'animation-fill-mode',
    'animation-iteration-count',
    'animation-name',
    'animation-play-state',
    'animation-timing-function',

    'backface-visibility',
    'background',
    'background-attachment',
    'background-blend-mode',
    'background-clip',
    'background-color',
    'background-image',
    'background-origin',
    'background-position',
    'background-repeat',
    'background-size',
    'border',
    'border-bottom',
    'border-bottom-color',
    'border-bottom-left-radius',
    'border-bottom-right-radius',
    'border-bottom-style',
    'border-bottom-width',
    'border-collapse',
    'border-color',
    'border-image',
    'border-image-outset',
    'border-image-repeat',
    'border-image-slice',
    'border-image-source',
    'border-image-width',
    'border-left',
    'border-left-color',
    'border-left-style',
    'border-left-width',
    'border-radius',
    'border-right',
    'border-right-color',
    'border-right-style',
    'border-right-width',
    'border-spacing',
    'border-style',
    'border-top',
    'border-top-color',
    'border-top-left-radius',
    'border-top-right-radius',
    'border-top-style',
    'border-top-width',
    'border-width',
    'bottom',
    'box-decoration-break',
    'box-shadow',
    'box-sizing',
    'break-after',
    'break-before',
    'break-inside',

    'caption-side',
    'caret-color',
    '@charset',
    'clear',
    'clip',
    'color',
    'column-count',
    'column-fill',
    'column-gap',
    'column-rule',
    'column-rule-color',
    'column-rule-style',
    'column-rule-width',
    'column-span',
    'column-width',
    'columns',
    'content',
    'counter-increment',
    'counter-reset',
    'cursor',

    'direction',
    'display',

    'empty-cells',

    'filter',
    'flex',
    'flex-basis',
    'flex-direction',
    'flex-flow',
    'flex-grow',
    'flex-shrink',
    'flex-wrap',
    'float',
    'font',
    '@font-face',
    'font-family',
    'font-feature-settings',
    '@font-feature-values',
    'font-kerning',
    'font-language-override',
    'font-size',
    'font-size-adjust',
    'font-stretch',
    'font-style',
    'font-synthesis',
    'font-variant',
    'font-variant-alternates',
    'font-variant-caps',
    'font-variant-east-asian',
    'font-variant-ligatures',
    'font-variant-numeric',
    'font-variant-position',
    'font-weight',

    'grid',
    'grid-area',
    'grid-auto-columns',
    'grid-auto-flow',
    'grid-auto-rows',
    'grid-column',
    'grid-column-end',
    'grid-column-gap',
    'grid-column-start',
    'grid-gap',
    'grid-row',
    'grid-row-end',
    'grid-row-gap',
    'grid-row-start',
    'grid-template',
    'grid-template-areas',
    'grid-template-columns',
    'grid-template-rows',

    'hanging-punctuation',
    'height',
    'hyphens',

    'image-orientation',
    'image-rendering',
    'image-resolution',

    'justify-content',

    '@keyframes',

    'left',
    'letter-spacing',
    'line-break',
    'line-height',
    'list-style',
    'list-style-image',
    'list-style-position',
    'list-style-type',

    'margin',
    'margin-bottom',
    'margin-left',
    'margin-right',
    'margin-top',
    'max-height',
    'max-width',
    '@media',
    'min-height',
    'min-width',

    'object-fit',
    'object-position',
    'opacity',
    'order',
    'orphans',
    'outline',
    'outline-color',
    'outline-offset',
    'outline-style',
    'outline-width',
    'overflow',
    'overflow-wrap',
    'overflow-x',
    'overflow-y',

    'padding',
    'padding-bottom',
    'padding-left',
    'padding-right',
    'padding-top',
    'page-break-after',
    'page-break-before',
    'page-break-inside',
    'perspective',
    'perspective-origin',
    'position',

    'quotes',

    'resize',
    'right',

    'tab-size',
    'table-layout',
    'text-align',
    'text-align-last',
    'text-combine-upright',
    'text-decoration',
    'text-decoration-color',
    'text-decoration-line',
    'text-decoration-style',
    'text-indent',
    'text-justify',
    'text-orientation',
    'text-overflow',
    'text-shadow',
    'text-transform',
    'text-underline-position',
    'top',
    'transform',
    'transform-origin',
    'transform-style',
    'transition',
    'transition-delay',
    'transition-duration',
    'transition-property',
    'transition-timing-function',

    'unicode-bidi',
    'user-select',

    'vertical-align',
    'visibility',

    'white-space',
    'widows',
    'width',
    'word-break',
    'word-spacing',
    'word-wrap',
    'writing-mode',

    'z-index',

    #EXTRA
    'mso-table-lspace',
    'mso-table-rspace',
]
    