#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: __init__.py 12819 2021-03-30 02:12:19Z Becca $
#
# Copyright (c) 2018 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Becca $ (last)
# $Date: 2021-03-30 10:12:19 +0800 (Tue, 30 Mar 2021) $
# $Revision: 12819 $

from django.conf import settings as _settings
from django.utils.translation import ugettext_lazy as _

class settings(object):
    ZEPHYRUS_OSCAR_FEATURED_DEFAULT_TEMPLATE = \
        "cms_oscar/Featured.html"
    ZEPHYRUS_OSCAR_LATEST_DEFAULT_TEMPLATE = \
        "cms_oscar/Latest.html"
    ZEPHYRUS_OSCAR_OFFER_DEFAULT_TEMPLATE = \
        "cms_oscar/Offer.html"
    ZEPHYRUS_OSCAR_OFFER_DEFAULT_TEMPLATE = \
        "cms_oscar/Bestseller.html"

    ZEPHYRUS_OSCAR_FEATURED_TEMPLATES = [
        (ZEPHYRUS_OSCAR_FEATURED_DEFAULT_TEMPLATE, _("Default")),
    ]

    ZEPHYRUS_OSCAR_LATEST_TEMPLATES = [
        (ZEPHYRUS_OSCAR_LATEST_DEFAULT_TEMPLATE, _("Default")),
    ]

    ZEPHYRUS_OSCAR_OFFER_TEMPLATES = [
        (ZEPHYRUS_OSCAR_OFFER_DEFAULT_TEMPLATE, _("Default")),
    ]

    ZEPHYRUS_OSCAR_BESTSELLER__TEMPLATES = [
        (ZEPHYRUS_OSCAR_BESTSELLER_DEFAULT_TEMPLATE, _("Default")),
    ]

    if hasattr(_settings, 'ZEPHYRUS_OSCAR_FEATURED_TEMPLATES'):
        for ele in _settings.ZEPHYRUS_OSCAR_FEATURED_TEMPLATES:
            if not ele[0] == ZEPHYRUS_OSCAR_FEATURED_DEFAULT_TEMPLATE:
                ZEPHYRUS_OSCAR_FEATURED_TEMPLATES.append(ele)

    if hasattr(_settings, 'ZEPHYRUS_OSCAR_LATEST_TEMPLATES'):
        for ele in _settings.ZEPHYRUS_OSCAR_LATEST_TEMPLATES:
            if not ele[0] == ZEPHYRUS_OSCAR_LATEST_DEFAULT_TEMPLATE:
                ZEPHYRUS_OSCAR_LATEST_TEMPLATES.append(ele)

    if hasattr(_settings, 'ZEPHYRUS_OSCAR_OFFER_TEMPLATES'):
        for ele in _settings.ZEPHYRUS_OSCAR_OFFER_TEMPLATES:
            if not ele[0] == ZEPHYRUS_OSCAR_OFFER_DEFAULT_TEMPLATE:
                ZEPHYRUS_OSCAR_OFFER_TEMPLATES.append(ele)

    if hasattr(_settings, 'ZEPHYRUS_OSCAR_OFFER_TEMPLATES'):
        for ele in _settings.ZEPHYRUS_OSCAR_BESTSELLER_TEMPLATE:
            if not ele[0] == ZEPHYRUS_OSCAR_BESTSELLER_DEFAULT_TEMPLATE:
                ZEPHYRUS_OSCAR_OFFER_TEMPLATES.append(ele)

