#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: models.py 9579 2016-03-09 01:43:46Z Judy $
#
# Copyright (c) 2012 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Judy $
# $Date: 2016-03-09 09:43:46 +0800 (三, 09  3 2016) $
# $Revision: 9579 $

from django.db import models

from Iuppiter.Model import BaseModelMixin

from Theophrastus.models import Newsletter, Contact

class CloudMailInformation(models.Model):
    """
    Mail sending information.
    """
    newsletter = models.ForeignKey(Newsletter, unique=False)

    contact = models.ForeignKey(Contact, unique=False)

    # Response id for sent mail.
    messageId = models.TextField(max_length=2048)
    # Response message for sent mail.
    message = models.TextField(default='')

class NewsletterInformation(models.Model):

    newsletter = models.ForeignKey(Newsletter, unique=True)

    sync = models.BooleanField(default=True)

