#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: admin.py 10642 2017-12-16 19:53:11Z David $
#
# Copyright (c) 2013 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: David $
# $Date: 2017-12-17 03:53:11 +0800 (Sun, 17 Dec 2017) $
# $Revision: 10642 $

from django.contrib import admin
from django.contrib.contenttypes import generic

from emencia.django.newsletter.models import Newsletter

from Theophrastus.newsletter_extension.models import Header, Footer
from Theophrastus.newsletter_extension.forms import HeaderTinyMCEForm
from Theophrastus.newsletter_extension.forms import FooterTinyMCEForm

class NewsletterHeaderline(generic.GenericTabularInline): #or generic.GenericStackedInline, this has different visual layout.
    model = Newsletter

    ct_field = "headerContentType"
    ct_fk_field = "headerId"
    fk_name = "header"

class NewsletterFooterline(generic.GenericTabularInline): #or generic.GenericStackedInline, this has different visual layout.
    model = Newsletter

    ct_field = "footerContentType"
    ct_fk_field = "footerId"
    fk_name = "footer"

class HeaderTinyMCEAdmin(admin.ModelAdmin):
    form = HeaderTinyMCEForm

    inlines = [
        NewsletterHeaderline,
    ]

admin.site.register(Header, HeaderTinyMCEAdmin)

class FooterTinyMCEAdmin(admin.ModelAdmin):
    form = FooterTinyMCEForm
    inlines = [
        NewsletterFooterline,
    ]


admin.site.register(Footer, FooterTinyMCEAdmin)
