#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: pluginize.py 11671 2019-08-07 04:50:27Z Lavender $
#
# Copyright (c) 2015 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2019-08-07 12:50:27 +0800 (週三, 07 八月 2019) $
# $Revision: 11671 $

import os
import json
import logging
import shutil
import hashlib
import traceback
import re

import cms

from django.core.management.base import BaseCommand, CommandError
from django.core.management import call_command
from django.test.client import RequestFactory
from django.db import transaction
from django.template.loader import get_template
from django.template import Context
from django.conf import settings
from django.template import Template

from djangocms_text_ckeditor.cms_plugins import TextPlugin
from cms.templatetags.cms_tags import *
from filer.models.filemodels import File
from cms.models.pagemodel import Page
from cms.models.pluginmodel import CMSPlugin
from lxml.html import fromstring
from html5lib import sanitizer
from html5lib.filters import sanitizer as filtersSanitizer

from Iuppiter.DjangoUtil import DJANGO_VERSION
from Zephyrus.boilerplate.management.commands import (
    TEMPLATES_DIR_PATH, STATIC_DIR_PATH, 
    FIXTURES_DIR_PATH, ROOT_DIR_PATH)
from Zephyrus.boilerplate.management.commands import (
    createLogger, CSS_PROPERTIES, toBytes)
from Zephyrus.boilerplate.management.commands import open3 as open

logger = createLogger(__name__, "Pluginize.log")

jsPath = os.path.join(STATIC_DIR_PATH, 'js', 'FixTemplate.js')
contextPath = os.path.join(STATIC_DIR_PATH, 'js', 'CMSContext.js')

complexity = 0

tagList = []

# To fix #2985 
sanitizer.HTMLSanitizerMixin.acceptable_css_properties = CSS_PROPERTIES
sanitizer.HTMLSanitizerMixin.allowed_css_properties = CSS_PROPERTIES

reString = ("^(#[0-9a-f]+|rgb\(\d+%?,\d*%?,?\d*%?\)?|\d{0,2}\.?\d{0,2}"
            "(cm|em|ex|in|mm|pc|pt|px|%|,|\))?)$")

def sanitize_css(self, style):
        # 刪除了前兩個判斷，其他都一樣
        if not re.match("^\s*([-\w]+\s*:[^:;]*(;\s*|$))*$", style):
            return ''

        clean = []
        for prop, value in re.findall("([-\w]+)\s*:\s*([^:;]*)", style):
            if not value:
                continue
            if prop.lower() in self.allowed_css_properties:
                clean.append(prop + ': ' + value + ';')
            elif prop.split('-')[0].lower() in ['background', 'border', 
                                                'margin', 'padding']:
                for keyword in value.split():
                    if keyword not in self.acceptable_css_keywords and \
                            not re.match(reString, keyword):
                        break
                else:
                    clean.append(prop + ': ' + value + ';')
            elif prop.lower() in self.allowed_svg_properties:
                clean.append(prop + ': ' + value + ';')

        return ' '.join(clean)

sanitizer.HTMLSanitizerMixin.sanitize_css = sanitize_css

class Attr(object):
    def __init__(self, name, value):
        self.name = name
        self.value = value 

class Tag(object):
    def __init__(self, tagName, placeholderName, md5, attrList):
        self.tag = tagName
        self.name = placeholderName
        self.md5 = md5
        self.attrList = attrList

    def __eq__(self, other):
        if self.name == other.name and self.tag == other.tag:
            return True
        return False

class Placeholder2(Placeholder):

    lang = 'zh-hant'

    def render_tag(self, context, name, extra_bits, nodelist=None):
        super(Placeholder2, self).render_tag(context, name,
                                                       extra_bits, nodelist)
        content = nodelist.render(context)
        
        self.writeContent(name, content)
        return content

    def writeContent(self, name, content):
        # get placeholderId by name in cms_placeholder
        # if placeholderId has no plugin, add textPlugin to cms_plugin
        # query plugin id, then write content to django_text_ckeditor_text
        from django.db import models
        from cms.models.placeholdermodel import Placeholder
        from cms.models.pluginmodel import CMSPlugin
        from djangocms_text_ckeditor.models import Text
        from cmsplugin_filer_image.models import FilerImage
        from djangocms_picture.models import Picture

        placeholders = Placeholder.objects.filter(slot=name)

        if os.path.isfile(os.path.join(ROOT_DIR_PATH, 'info.json')):
            with open(os.path.join(ROOT_DIR_PATH, 'info.json')) as jsonfile:
                data = json.load(jsonfile)

            if 'complexity' in data:
                data['complexity'] = \
                    data['complexity'] + (len(placeholders) / 2)
            else:
                data['complexity'] = len(placeholders) / 2

            with open(os.path.join(ROOT_DIR_PATH, 'info.json'), 'w') as f:
                line = json.dumps(data)
                f.write(line)
        
        for placeholder in placeholders:
            # logger.info("id: %s, name: %s" % (placeholder.id, placeholder.slot))
            hasPlugin = CMSPlugin.objects.filter(
                                        placeholder=placeholder).exists()

            if not hasPlugin:
                string = content.lower().strip()
                
                isOutSideTag = False
                if string.startswith('<') and string.endswith('>'):
                    isOutSideTag = True

                isImgTag = False
                if '>' in string:
                    index = string.index('>')
                    if index == len(string) - 1:
                        isImgTag = True
                        
                isImgA = False
                if isOutSideTag and string.startswith('<a'):
                    root = fromstring(content)
                    children = root.getchildren()
                    if len(children) == 1:
                       if children[0].tag == 'img':
                           isImgA = True
                     
                if (string.startswith('<img') and isImgTag) or isImgA:
                    
                    root = fromstring(content)
                    
                    if isImgA:
                        img = root.getchildren()[0]
                        # add a attrs
                        attrList = []
                        aAttrDict = {}
                        attrs = root.items()
                        for k, v in attrs:
                            if k == 'href':
                                continue
                            attrList.append(Attr(k, v))
                            aAttrDict[k] = v
                        
                        
                        tagList.append(
                            Tag('a', placeholder.slot, 
                            hashlib.md5(
                                toBytes(placeholder.slot)).hexdigest(), attrList))
                    else:
                        img = root
                    
                    
                    # find img src
                    url = img.get('src')
                    if url is None:
                        continue

                    if url.startswith("{% static \"") and url.endswith("\" %}"):
                        url = "/static/" + url[12:-4]

                    # add img attrs
                    attrList = []
                    imgAttrDict = {}
                    attrs = img.items()
                    for k, v in attrs:
                        if k == 'src':
                            continue
                        attrList.append(Attr(k, v))
                        imgAttrDict[k] = v
                    
                    
                    tagList.append(
                        Tag('img', placeholder.slot, 
                        hashlib.md5(
                            toBytes(placeholder.slot)).hexdigest(), attrList))
                    
                    if not cms.__version__.startswith('3.4'):
                        if root.tag == 'a':
                            link = root.get('href')
                            if link == '' or link == None:
                                link = '#'
                            Picture.objects.create(
                                placeholder=placeholder,
                                language=Placeholder2.lang,
                                plugin_type='PicturePlugin',
                                link_url=link,
                                external_picture=url,
                                attributes=imgAttrDict,
                                link_attributes=aAttrDict,
                            )                    
                        else:
                            Picture.objects.create(
                                placeholder=placeholder,
                                language=Placeholder2.lang,
                                plugin_type='PicturePlugin',
                                external_picture=url,
                                attributes=imgAttrDict,
                            )                    
                    else:
                        if root.tag == 'a':
                            link = root.get('href')
                            FilerImage.objects.create(
                                placeholder=placeholder,
                                language=Placeholder2.lang,
                                caption_text='', image_url=url,
                                plugin_type='FilerImagePlugin',
                                free_link=link)

                        else:
                            FilerImage.objects.create(
                                placeholder=placeholder,
                                language=Placeholder2.lang,
                                caption_text='', image_url=url,
                                plugin_type='FilerImagePlugin',)
                    
                else:
                    textPlugin = Text.objects.create(
                        placeholder=placeholder,
                        language=Placeholder2.lang,
                        body=content, plugin_type='TextPlugin')

class Command(BaseCommand):
    
    help = 'Add TextPlugin to default placeholders which are without plugin.'
    args = '[language]'
    
    # Validation is called explicitly each time the server is reloaded.
    requires_model_validation = False
    
    def add_arguments(self, parser):
        parser.add_argument(
                '-t', '--template', 
                type=str,
                help="template name.")

        parser.add_argument(
                '-d', '--templateDir', 
                type=str,
                help="template dir name.")
    
    def handle(self, language='', *args, **options):
        try:
            from django import template
            from django.core.urlresolvers import reverse
            from django.contrib.auth.models import AnonymousUser
            
            from sekizai.context import SekizaiContext
            
            from cms.templatetags.cms_tags import register
            
            if language:
                Placeholder2.lang = language
            else:
                if hasattr(settings, 'LANGUAGE_CODE'):
                    Placeholder2.lang = settings.LANGUAGE_CODE
            
            register.tags['placeholder'] = Placeholder2
            #register.tag(Placeholder2)
            
            if options['templateDir']:
                path = os.path.join(TEMPLATES_DIR_PATH, options['templateDir'])
            else:
                path = TEMPLATES_DIR_PATH

            logger.info('Processing...')

            if not os.path.exists(os.path.join(STATIC_DIR_PATH, 'js')):
                os.mkdir(os.path.join(STATIC_DIR_PATH, 'js'))
                
            if not os.path.exists(FIXTURES_DIR_PATH):
                os.mkdir(FIXTURES_DIR_PATH)
                with open(
                    os.path.join(FIXTURES_DIR_PATH, '__init__.py'), 'w') as f:
                    pass
                
            if os.path.isfile(os.path.join(ROOT_DIR_PATH, 'info.json')):
                with open(os.path.join(ROOT_DIR_PATH, 'info.json')) as jsonfile:
                    data = json.load(jsonfile)

                data['pages'] = len(os.listdir(path))

                with open(os.path.join(ROOT_DIR_PATH, 'info.json'), 'w') as f:
                    line = json.dumps(data)
                    f.write(line)

            @transaction.atomic
            def process():
                for root, dirs, files in os.walk(path):
                    for file in files:
                        if (path.endswith('/') or 
                            path.endswith('\\')):
                            templatePath = os.path.join(
                                root.replace(path, ''), 
                                file
                            )
                        else:
                            # 去掉第一個 / or \
                            templatePath = os.path.join(
                                root.replace(path, '')[1:], 
                                file
                            )
                        
                        if options['template']:
                            if not templatePath == options['template']:
                                continue
                        file = os.path.join(path, templatePath)
                        
                        result = os.path.splitext(file)[-1]
                        if not result == ".html":
                            continue
                            
                        logger.info(file)
                        
                        f = open(file)
                        t = template.Template(f.read())
                        c = SekizaiContext()
                        factory = RequestFactory()
                        c['request'] = factory.get('/' + Placeholder2.lang + '/')
                        c['request'].user = AnonymousUser()
                        c['request'].current_page = Page.objects.get(pk=1)
                        t.render(c)
                        f.close()
                        

            process()
            
            # Unique List obj
            newTagList = []
            for tag in tagList:
                notAdd = False
                for tag2 in newTagList:
                    if tag2 == tag:
                        notAdd = True
                if not notAdd:
                    newTagList.append(tag)

            # build FixTemplate.js
            temp = get_template('boilerplate/js/FixTemplate.js')
            content = temp.render()
            with open(jsPath, 'w') as f:
                f.write(content)

            # build CMSContext.js
            if cms.__version__.startswith('3.4'):
                temp = get_template('boilerplate/js/CMSContext.js')
                if DJANGO_VERSION >= 11100: # django >= 1.11
                    replaceStr = {
                        'tagList': newTagList, 
                    }
                else:
                    replaceStr = Context({
                        'tagList': newTagList, 
                    })
                content = temp.render(replaceStr)
                with open(contextPath, 'w') as f:
                    f.write(content)

            if os.path.isfile(os.path.join(ROOT_DIR_PATH, 'info.json')):
                with open(os.path.join(ROOT_DIR_PATH, 'info.json')) as jsonfile:
                    data = json.load(jsonfile)
            
                if 'complexity' in data:
                    logger.info('Complexity : %d' % data['complexity'])
                else:
                    logger.error('%s Complexity = 0' % data['slug'])
                    raise CommandError('%s Complexity = 0' % data['slug'])
                if 'upc' in data:
                    logger.info('UPC : %s' % data['upc'])

                for file in os.listdir(path):
                    file = os.path.join(path, file)
                    with open(file) as f:
                        content = f.read()
                    content = content.replace(
                        "complexity=CMS_PLUGINIZE_REPLACE", 
                        "complexity=%d" % data['complexity'])
                    with open(file, 'w') as f:
                        f.write(content)
            
            logger.info('DONE!')
        except Exception as e:
            logger.error("pluginize error:%s" % e)
            with open('./AllError.log', 'w+') as log:
                log.write(traceback.format_exc())
            raise
        

        
                        