#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: setup.py 12427 2020-07-26 06:50:17Z Bear $
#
# Copyright (c) 2020 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Bear $ (last)
# $Date: 2020-07-26 14:50:17 +0800 (Sun, 26 Jul 2020) $
# $Revision: 12427 $

import os
import warnings

try:
    from Iuppiter.DistUtil import setup
except ImportError:
    os.system('pip install Iuppiter --no-cache-dir')
    from Iuppiter.DistUtil import setup
    
import sys

if sys.version_info.major == 3:
    if sys.version_info[:2] >= (3, 6):
        extraRequirements = [
            'pip install mysqlclient==1.4.2.post1',
        ]
    else:
        extraRequirements = [
            'pip install mysqlclient==1.3.12',
        ]
    extraRequirements.extend([
        'pip install raven==6.10.0',
        # celery 安裝 4.3 cloud 寄信時 Asynchronous 會出現 Send message failed, 
        # reason: 'NoneType' object is not callable
        #'pip install celery==4.2.2',
        # py3.7後，升級為 celery 4.4.5
        'pip install celery==4.4.6',
        'pip install redis==3.5.3'])
else:
    extraRequirements = [
        'pip install mysqlclient==1.3.7',
        'pip install raven==4.0.4',
        'pip install celery==3.1.25',
        'pip install amqp==1.4.9',
        'pip install redis==2.10.3'
    ]

from sys import platform as _platform

# Python for Window Extensions (pypiwin32) is only for Windows.
if _platform == "win32":
    # win32 (https://pypi.python.org/pypi/pypiwin32/219)
    extraRequirements.append('pip install pypiwin32')   

# 要改版本號，請去改 Iuno.Version
import six

kwargs = {} if six.PY2 else {'encoding': 'utf8',}
with open(os.path.join('Iuno', 'Version.py'), **kwargs) as f:
    content = f.read()
    exec(content)

setup(
    'Iuno',
    description="Support package for all Nuwa Information's server projects.",
    version=IUNO_VERSION,
    license='Proprietary License',
    author='Bear',
    author_email='bear@nuwainfo.com',
    url='http://www.nuwainfo.com/',
	extraRequirements=extraRequirements,
    extrasRequire={
        'scrapy': "REQUIREMENTS_SCRAPY.txt",
    }
)
