#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: __init__.py 11599 2019-06-01 18:56:30Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2019-06-02 03:56:30 +0900 (週日, 02 六月 2019) $
# $Revision: 11599 $

from django.conf import settings as _settings
from django.utils.translation import ugettext_lazy as _

default_app_config = 'Zephyrus.comment.apps.CommentConfig'

class settings(object):
    ZEPHYRUS_COMMENT_DEFAULT_TEMPLATE = \
        "comment/Default.html"

    ZEPHYRUS_COMMENT_TEMPLATES = [
        (ZEPHYRUS_COMMENT_DEFAULT_TEMPLATE, _("Default")),
    ]

    ZEPHYRUS_RECENTRESPONSE_DEFAULT_TEMPLATE = \
        "comment/RecentResponse.html"

    ZEPHYRUS_RECENTRESPONSE_TEMPLATES = [
        (ZEPHYRUS_RECENTRESPONSE_DEFAULT_TEMPLATE, _("Default")),
    ]

    if hasattr(_settings, 'ZEPHYRUS_COMMENT_TEMPLATES'):
        for ele in _settings.ZEPHYRUS_COMMENT_TEMPLATES:
            if not ele[0] == ZEPHYRUS_COMMENT_DEFAULT_TEMPLATE:
                ZEPHYRUS_COMMENT_TEMPLATES.append(ele)
    
    if hasattr(_settings, 'ZEPHYRUS_RECENTRESPONSE_TEMPLATES'):
        for ele in _settings.ZEPHYRUS_RECENTRESPONSE_TEMPLATES:
            if not ele[0] == ZEPHYRUS_RECENTRESPONSE_DEFAULT_TEMPLATE:
                ZEPHYRUS_RECENTRESPONSE_TEMPLATES.append(ele)
