#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: emails.py 1288 2016-08-03 08:25:39Z Eric $
#
# Copyright (c) 2016 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Eric $ (last)
# $Date: 2016-08-03 16:25:39 +0800 (Wed, 03 Aug 2016) $
# $Revision: 1288 $

import urllib
import urllib2

from Iuppiter.Encoding import utf8

class SMS(object):

    def __init__(self, phones, message, username='', password='',
                 method='1', date=None, hour=None, min=None, **kws):
        """         
        Constructor.
        
        @param phones The phone numbers that you want to send. Max length: 250.
        @param message Message.
        @param username Your username.
        @param password Your password.
        @param method Method to send message. '1': immediate, '2': reserved
        @param date Send date if method is 'reserved'. Format: YYYY/MM/DD
        @param hour Send hour if method is 'reserved'. Format: 00~23
        @param min Send date if min is 'reserved'. Format: 00~59
        """
        if method == '1':
            self.postData = [
                ('username', username if username else 'nuwa'),
                ('password', password if password else 'nuwa25025529'),
                ('method', method),
                ('phone', phones),
                ('sms_msg', utf8(message))
            ]
        elif method == '2':
            self.postData = [
                ('username', username if username else 'nuwa'),
                ('password', password if password else 'nuwa25025529'),
                ('method', method),
                ('phone', phones),
                ('sms_msg', utf8(message)),
                ('send_date', date),
                ('hour', date),
                ('min', date),
            ]
        else:
            pass

    
    def sendMessage(self):
        """
        Send SMS message.
        
        return Sms sent result string. Format: {"stats":true,
                                                "error_code":"000",
                                                "error_msg":"1646437|1|2"}
        """
        result = urllib2.urlopen('http://sms-get.com/api_send.php?' + \
                                  urllib.urlencode(self.postData))
        return result.read()
        
        